/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.handler.admin;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.DatabaseAdminQueryProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.DatabaseAdminUpdateProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutorCreator;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminQueryExecutor;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;

public final class DatabaseAdminProxyBackendHandlerFactory {
    public static Optional<ProxyBackendHandler> newInstance(DatabaseType databaseType, SQLStatementContext sqlStatementContext, ConnectionSession connectionSession, String sql, List<Object> parameters) {
        Optional executorCreator = DatabaseTypedSPILoader.findService(DatabaseAdminExecutorCreator.class, (DatabaseType)databaseType);
        if (!executorCreator.isPresent()) {
            return Optional.empty();
        }
        Optional<DatabaseAdminExecutor> executor = ((DatabaseAdminExecutorCreator)executorCreator.get()).create(sqlStatementContext, sql, connectionSession.getUsedDatabaseName(), parameters);
        return executor.map(optional -> DatabaseAdminProxyBackendHandlerFactory.createProxyBackendHandler(sqlStatementContext, connectionSession, optional));
    }

    private static ProxyBackendHandler createProxyBackendHandler(SQLStatementContext sqlStatementContext, ConnectionSession connectionSession, DatabaseAdminExecutor executor) {
        ContextManager contextManager = ProxyContext.getInstance().getContextManager();
        return executor instanceof DatabaseAdminQueryExecutor ? new DatabaseAdminQueryProxyBackendHandler(contextManager, connectionSession, (DatabaseAdminQueryExecutor)executor) : new DatabaseAdminUpdateProxyBackendHandler(contextManager, connectionSession, sqlStatementContext.getSqlStatement(), executor);
    }

    @Generated
    private DatabaseAdminProxyBackendHandlerFactory() {
    }
}

