/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.generic;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.binary.BinaryRow;
import org.apache.shardingsphere.database.protocol.firebird.packet.FirebirdPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.generic.FirebirdFetchResponsePacket;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdSQLResponsePacket
extends FirebirdPacket {
    private final int messageCount;
    private final BinaryRow data;

    public FirebirdSQLResponsePacket() {
        this.messageCount = 0;
        this.data = null;
    }

    public FirebirdSQLResponsePacket(BinaryRow row) {
        this.messageCount = 1;
        this.data = row;
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
        payload.writeInt4(FirebirdCommandPacketType.SQL_RESPONSE.getValue());
        payload.writeInt4(this.messageCount);
        FirebirdFetchResponsePacket.writeRowData(payload, this.data);
    }

    @Generated
    public int getMessageCount() {
        return this.messageCount;
    }

    @Generated
    public BinaryRow getData() {
        return this.data;
    }
}

