/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.util.FirebirdDateTimeUtils;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdTimestampTZBinaryProtocolValue
implements FirebirdBinaryProtocolValue {
    @Override
    public Object read(FirebirdPacketPayload payload) {
        return FirebirdDateTimeUtils.getDateTimeWithOffset(payload.readInt4(), payload.readInt4(), payload.readInt4());
    }

    @Override
    public void write(FirebirdPacketPayload payload, Object value) {
        LocalDateTime localDateTime = ((OffsetDateTime)value).atZoneSameInstant(ZoneOffset.UTC).toLocalDateTime();
        payload.writeInt4(FirebirdDateTimeUtils.getEncodedDate(localDateTime));
        payload.writeInt4(new FirebirdDateTimeUtils(localDateTime).getEncodedTime());
        payload.writeInt4(((OffsetDateTime)value).getOffset().getTotalSeconds() / 60);
    }

    @Override
    public int getLength(FirebirdPacketPayload payload) {
        return 12;
    }
}

