/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.shardingsphere.database.protocol.firebird.constant.protocol.FirebirdProtocolVersion;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacket;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.FirebirdCommandPacketType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.FirebirdBinaryColumnType;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBinaryProtocolValue;
import org.apache.shardingsphere.database.protocol.firebird.packet.command.query.statement.execute.protocol.FirebirdBinaryProtocolValueFactory;
import org.apache.shardingsphere.database.protocol.firebird.payload.FirebirdPacketPayload;

public final class FirebirdExecuteStatementPacket
extends FirebirdCommandPacket {
    private final FirebirdCommandPacketType type;
    private final int statementId;
    private final int transactionId;
    private final List<FirebirdBinaryColumnType> parameterTypes;
    private final int message;
    private final List<Object> parameterValues = new ArrayList<Object>();
    private final List<FirebirdBinaryColumnType> returnColumns = new ArrayList<FirebirdBinaryColumnType>();
    private int outputMessageNumber;
    private long statementTimeout;
    private long cursorFlags;
    private long maxBlobSize;

    public FirebirdExecuteStatementPacket(FirebirdPacketPayload payload, FirebirdProtocolVersion protocolVersion) {
        this.type = FirebirdCommandPacketType.valueOf(payload.readInt4());
        this.statementId = payload.readInt4();
        this.transactionId = payload.readInt4();
        this.parameterTypes = this.parseBLR(payload.readBuffer());
        this.message = payload.readInt4();
        int msgCount = payload.readInt4();
        ArrayList<Integer> nullBits = new ArrayList<Integer>();
        if (msgCount > 0) {
            int length = (this.parameterTypes.size() + 7) / 8;
            for (int i = 0; i < length; ++i) {
                nullBits.add(payload.readInt1());
            }
            payload.skipPadding(length);
        }
        for (int i = 0; i < this.parameterTypes.size(); ++i) {
            Integer nullBit = (Integer)nullBits.get(i / 8);
            if ((nullBit >> i % 8 & 1) == 0) {
                FirebirdBinaryColumnType parameterType = this.parameterTypes.get(i);
                FirebirdBinaryProtocolValue binaryProtocolValue = FirebirdBinaryProtocolValueFactory.getBinaryProtocolValue(parameterType);
                if (parameterType == FirebirdBinaryColumnType.BLOB) {
                    this.parameterValues.add(payload.readInt8());
                    continue;
                }
                this.parameterValues.add(binaryProtocolValue.read(payload));
                continue;
            }
            this.parameterValues.add(null);
        }
        if (this.isStoredProcedure()) {
            this.returnColumns.addAll(this.parseBLR(payload.readBuffer()));
            this.outputMessageNumber = payload.readInt4();
        }
        if (protocolVersion.getCode() >= FirebirdProtocolVersion.PROTOCOL_VERSION16.getCode()) {
            this.statementTimeout = payload.readInt4Unsigned();
        }
        if (protocolVersion.getCode() >= FirebirdProtocolVersion.PROTOCOL_VERSION18.getCode()) {
            this.cursorFlags = payload.readInt4Unsigned();
        }
        if (protocolVersion.getCode() >= FirebirdProtocolVersion.PROTOCOL_VERSION19.getCode()) {
            this.maxBlobSize = payload.readInt4Unsigned();
        }
    }

    private List<FirebirdBinaryColumnType> parseBLR(ByteBuf blrBuffer) {
        if (!blrBuffer.isReadable()) {
            return new ArrayList<FirebirdBinaryColumnType>(0);
        }
        blrBuffer.skipBytes(4);
        int length = blrBuffer.readUnsignedByte();
        ArrayList<FirebirdBinaryColumnType> result = new ArrayList<FirebirdBinaryColumnType>((length += 256 * blrBuffer.readUnsignedByte()) / 2);
        short blrType = blrBuffer.readUnsignedByte();
        while (blrType != 255) {
            FirebirdBinaryColumnType type = FirebirdBinaryColumnType.valueOfBLRType(blrType);
            result.add(type);
            blrBuffer.skipBytes(this.getSkipCount(type) + 2);
            blrType = blrBuffer.readUnsignedByte();
        }
        return result;
    }

    private int getSkipCount(FirebirdBinaryColumnType type) {
        switch (type) {
            case VARYING: 
            case TEXT: {
                return 4;
            }
            case NULL: 
            case LEGACY_TEXT: 
            case LEGACY_VARYING: {
                return 2;
            }
            case BLOB: 
            case ARRAY: 
            case LONG: 
            case SHORT: 
            case INT64: 
            case QUAD: 
            case INT128: {
                return 1;
            }
        }
        return 0;
    }

    public boolean isStoredProcedure() {
        return this.type == FirebirdCommandPacketType.EXECUTE2;
    }

    @Override
    protected void write(FirebirdPacketPayload payload) {
    }

    public static int getLength(FirebirdPacketPayload payload, FirebirdProtocolVersion protocolVersion) {
        new FirebirdExecuteStatementPacket(payload, protocolVersion);
        int length = payload.getByteBuf().readerIndex();
        payload.getByteBuf().resetReaderIndex();
        return length;
    }

    @Generated
    public FirebirdCommandPacketType getType() {
        return this.type;
    }

    @Generated
    public int getStatementId() {
        return this.statementId;
    }

    @Generated
    public int getTransactionId() {
        return this.transactionId;
    }

    @Generated
    public List<FirebirdBinaryColumnType> getParameterTypes() {
        return this.parameterTypes;
    }

    @Generated
    public int getMessage() {
        return this.message;
    }

    @Generated
    public List<Object> getParameterValues() {
        return this.parameterValues;
    }

    @Generated
    public List<FirebirdBinaryColumnType> getReturnColumns() {
        return this.returnColumns;
    }

    @Generated
    public int getOutputMessageNumber() {
        return this.outputMessageNumber;
    }

    @Generated
    public long getStatementTimeout() {
        return this.statementTimeout;
    }

    @Generated
    public long getCursorFlags() {
        return this.cursorFlags;
    }

    @Generated
    public long getMaxBlobSize() {
        return this.maxBlobSize;
    }
}

