/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.factory;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.proxy.backend.handler.admin.executor.DatabaseAdminExecutor;
import org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.executor.OpenGaussSelectPasswordDeadlineExecutor;
import org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.executor.OpenGaussSelectPasswordNotifyTimeExecutor;
import org.apache.shardingsphere.proxy.backend.opengauss.handler.admin.executor.OpenGaussSelectVersionExecutor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.dml.item.ExpressionProjectionSegment;

public final class OpenGaussSystemFunctionQueryExecutorFactory {
    public static Optional<DatabaseAdminExecutor> newInstance(SelectStatementContext sqlStatementContext) {
        List projections = sqlStatementContext.getSqlStatement().getProjections().getProjections();
        if (1 != projections.size() || !(projections.iterator().next() instanceof ExpressionProjectionSegment)) {
            return Optional.empty();
        }
        String functionName = ((ExpressionProjectionSegment)projections.iterator().next()).getText();
        if (OpenGaussSelectVersionExecutor.accept(functionName)) {
            return Optional.of(new OpenGaussSelectVersionExecutor());
        }
        if (OpenGaussSelectPasswordDeadlineExecutor.accept(functionName)) {
            return Optional.of(new OpenGaussSelectPasswordDeadlineExecutor(functionName));
        }
        if (OpenGaussSelectPasswordNotifyTimeExecutor.accept(functionName)) {
            return Optional.of(new OpenGaussSelectPasswordNotifyTimeExecutor());
        }
        return Optional.empty();
    }

    @Generated
    private OpenGaussSystemFunctionQueryExecutorFactory() {
    }
}

