/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.context.Context;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.CompletableResultCode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InternalTelemetryVersion;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.internal.ComponentId;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.ReadWriteSpan;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.ReadableSpan;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.SpanProcessor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.data.SpanData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SimpleSpanProcessorBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.trace.export.SpanProcessorInstrumentation;

public final class SimpleSpanProcessor
implements SpanProcessor {
    private static final ComponentId COMPONENT_ID = ComponentId.generateLazy("simple_span_processor");
    private static final Logger logger = Logger.getLogger(SimpleSpanProcessor.class.getName());
    private final SpanExporter spanExporter;
    private final boolean exportUnsampledSpans;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private final SpanProcessorInstrumentation spanProcessorInstrumentation;
    private final Object exporterLock = new Object();

    public static SpanProcessor create(SpanExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return SimpleSpanProcessor.builder(exporter).build();
    }

    public static SimpleSpanProcessorBuilder builder(SpanExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return new SimpleSpanProcessorBuilder(exporter);
    }

    SimpleSpanProcessor(SpanExporter spanExporter, boolean exportUnsampledSpans, Supplier<MeterProvider> meterProvider) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
        this.exportUnsampledSpans = exportUnsampledSpans;
        this.spanProcessorInstrumentation = SpanProcessorInstrumentation.get(InternalTelemetryVersion.LATEST, COMPONENT_ID, meterProvider);
    }

    @Override
    public void onStart(Context parentContext, ReadWriteSpan span) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEnd(ReadableSpan span) {
        if (span != null && (this.exportUnsampledSpans || span.getSpanContext().isSampled())) {
            try {
                CompletableResultCode result;
                List<SpanData> spans = Collections.singletonList(span.toSpanData());
                Object object = this.exporterLock;
                synchronized (object) {
                    result = this.spanExporter.export(spans);
                }
                this.pendingExports.add(result);
                result.whenComplete(() -> {
                    this.pendingExports.remove(result);
                    String error = null;
                    if (!result.isSuccess()) {
                        logger.log(Level.FINE, "Exporter failed");
                        error = result.getFailureThrowable() != null ? result.getFailureThrowable().getClass().getName() : "export_failed";
                    }
                    this.spanProcessorInstrumentation.finishSpans(1, error);
                });
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Exporter threw an Exception", e);
            }
        }
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode result = new CompletableResultCode();
        CompletableResultCode flushResult = this.forceFlush();
        flushResult.whenComplete(() -> {
            CompletableResultCode shutdownResult = this.spanExporter.shutdown();
            shutdownResult.whenComplete(() -> {
                if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                    result.fail();
                } else {
                    result.succeed();
                }
            });
        });
        return result;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }

    public SpanExporter getSpanExporter() {
        return this.spanExporter;
    }

    public String toString() {
        return "SimpleSpanProcessor{spanExporter=" + this.spanExporter + ", exportUnsampledSpans=" + this.exportUnsampledSpans + '}';
    }
}

