/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator;

import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.api.common.Attributes;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.DoublePointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.MetricData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.AbstractSumAggregator;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.concurrent.AdderUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.concurrent.DoubleAdder;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.ImmutableDoublePointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.ImmutableSumData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.data.MutableDoublePointData;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoirFactory;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.resources.Resource;

public final class DoubleSumAggregator
extends AbstractSumAggregator<DoublePointData, DoubleExemplarData> {
    private final ExemplarReservoirFactory reservoirFactory;
    private final MemoryMode memoryMode;

    public DoubleSumAggregator(InstrumentDescriptor instrumentDescriptor, ExemplarReservoirFactory reservoirFactory, MemoryMode memoryMode) {
        super(instrumentDescriptor);
        this.reservoirFactory = reservoirFactory;
        this.memoryMode = memoryMode;
    }

    @Override
    public AggregatorHandle<DoublePointData> createHandle() {
        return new Handle(this.reservoirFactory, this.memoryMode);
    }

    @Override
    public DoublePointData diff(DoublePointData previousPoint, DoublePointData currentPoint) {
        return ImmutableDoublePointData.create(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousPoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public void diffInPlace(DoublePointData previousReusablePoint, DoublePointData currentPoint) {
        ((MutableDoublePointData)previousReusablePoint).set(currentPoint.getStartEpochNanos(), currentPoint.getEpochNanos(), currentPoint.getAttributes(), currentPoint.getValue() - previousReusablePoint.getValue(), currentPoint.getExemplars());
    }

    @Override
    public DoublePointData createReusablePoint() {
        return new MutableDoublePointData();
    }

    @Override
    public void copyPoint(DoublePointData point, DoublePointData toReusablePoint) {
        ((MutableDoublePointData)toReusablePoint).set(point);
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor descriptor, Collection<DoublePointData> points, AggregationTemporality temporality) {
        return ImmutableMetricData.createDoubleSum(resource, instrumentationScopeInfo, descriptor.getName(), descriptor.getDescription(), descriptor.getSourceInstrument().getUnit(), ImmutableSumData.create(this.isMonotonic(), temporality, points));
    }

    static final class Handle
    extends AggregatorHandle<DoublePointData> {
        private final DoubleAdder current = AdderUtil.createDoubleAdder();
        @Nullable
        private final MutableDoublePointData reusablePoint;

        Handle(ExemplarReservoirFactory reservoirFactory, MemoryMode memoryMode) {
            super(reservoirFactory, true);
            this.reusablePoint = memoryMode == MemoryMode.REUSABLE_DATA ? new MutableDoublePointData() : null;
        }

        @Override
        protected DoublePointData doAggregateThenMaybeResetDoubles(long startEpochNanos, long epochNanos, Attributes attributes, List<DoubleExemplarData> exemplars, boolean reset) {
            double value;
            double d = value = reset ? this.current.sumThenReset() : this.current.sum();
            if (this.reusablePoint != null) {
                this.reusablePoint.set(startEpochNanos, epochNanos, attributes, value, exemplars);
                return this.reusablePoint;
            }
            return ImmutableDoublePointData.create(startEpochNanos, epochNanos, attributes, value, exemplars);
        }

        @Override
        protected void doRecordDouble(double value) {
            this.current.add(value);
        }
    }
}

