/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal;

import java.lang.reflect.Method;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.FallbackStringEncoder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.StringEncoder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.UnsafeStringEncoder;

public final class StringEncoderHolder {
    private static final Logger logger = Logger.getLogger(StringEncoderHolder.class.getName());
    static final StringEncoder INSTANCE = StringEncoderHolder.createInstance();

    public static StringEncoder createFallbackEncoder() {
        return new FallbackStringEncoder();
    }

    @Nullable
    public static StringEncoder createUnsafeEncoder() {
        return UnsafeStringEncoder.createIfAvailable();
    }

    @Nullable
    public static StringEncoder createVarHandleEncoder() {
        try {
            Class<?> varHandleClass = Class.forName("org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.VarHandleStringEncoder");
            Method createMethod = varHandleClass.getMethod("createIfAvailable", new Class[0]);
            return (StringEncoder)createMethod.invoke(null, new Object[0]);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static StringEncoder createInstance() {
        StringEncoder unsafeImpl;
        if (!StringEncoderHolder.proactivelyAvoidUnsafe() && (unsafeImpl = StringEncoderHolder.createUnsafeEncoder()) != null) {
            logger.log(Level.FINE, "Using UnsafeStringEncoder for optimized Java 8+ performance");
            return unsafeImpl;
        }
        StringEncoder varHandleImpl = StringEncoderHolder.createVarHandleEncoder();
        if (varHandleImpl != null) {
            logger.log(Level.FINE, "Using VarHandleStringEncoder for optimal Java 9+ performance");
            return varHandleImpl;
        }
        logger.log(Level.FINE, "Using FallbackStringEncoder");
        return StringEncoderHolder.createFallbackEncoder();
    }

    private static boolean proactivelyAvoidUnsafe() {
        Optional<Double> javaVersion = StringEncoderHolder.getJavaVersion();
        return javaVersion.map(version -> version >= 23.0).orElse(true);
    }

    private static Optional<Double> getJavaVersion() {
        String specVersion = System.getProperty("java.specification.version");
        if (specVersion != null) {
            try {
                return Optional.of(Double.parseDouble(specVersion));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    private StringEncoderHolder() {
    }
}

