/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.node;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDataSource;
import org.apache.shardingsphere.infra.state.datasource.DataSourceState;
import org.apache.shardingsphere.infra.state.datasource.qualified.QualifiedDataSourceState;
import org.apache.shardingsphere.infra.state.datasource.qualified.yaml.YamlQualifiedDataSourceState;
import org.apache.shardingsphere.infra.state.datasource.qualified.yaml.YamlQualifiedDataSourceStateSwapper;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.node.path.NodePath;
import org.apache.shardingsphere.mode.node.path.engine.generator.NodePathGenerator;
import org.apache.shardingsphere.mode.node.path.type.global.node.storage.QualifiedDataSourceNodePath;
import org.apache.shardingsphere.mode.spi.repository.PersistRepository;

public final class QualifiedDataSourceStatePersistService {
    private final PersistRepository repository;

    public Map<String, QualifiedDataSourceState> load() {
        List qualifiedDataSourceNodes = this.repository.getChildrenKeys(NodePathGenerator.toPath((NodePath)new QualifiedDataSourceNodePath((String)null)));
        HashMap<String, QualifiedDataSourceState> result = new HashMap<String, QualifiedDataSourceState>(qualifiedDataSourceNodes.size(), 1.0f);
        qualifiedDataSourceNodes.forEach(each -> {
            String yamlContent = this.repository.query(NodePathGenerator.toPath((NodePath)new QualifiedDataSourceNodePath(new QualifiedDataSource(each))));
            if (!Strings.isNullOrEmpty((String)yamlContent)) {
                result.put((String)each, new YamlQualifiedDataSourceStateSwapper().swapToObject((YamlQualifiedDataSourceState)YamlEngine.unmarshal((String)yamlContent, YamlQualifiedDataSourceState.class)));
            }
        });
        return result;
    }

    public void update(String databaseName, String groupName, String storageUnitName, DataSourceState dataSourceState) {
        QualifiedDataSourceState status = new QualifiedDataSourceState(dataSourceState);
        this.repository.persist(NodePathGenerator.toPath((NodePath)new QualifiedDataSourceNodePath(new QualifiedDataSource(databaseName, groupName, storageUnitName))), YamlEngine.marshal((Object)new YamlQualifiedDataSourceStateSwapper().swapToYamlConfiguration(status)));
    }

    @Generated
    public QualifiedDataSourceStatePersistService(PersistRepository repository) {
        this.repository = repository;
    }
}

