/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.pushdown.type.table;

import java.util.LinkedList;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.mode.metadata.refresher.pushdown.PushDownMetaDataRefresher;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.table.RenameTableDefinitionSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.RenameTableStatement;

public final class RenameTablePushDownMetaDataRefresher
implements PushDownMetaDataRefresher<RenameTableStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, String logicDataSourceName, String schemaName, DatabaseType databaseType, RenameTableStatement sqlStatement, ConfigurationProperties props) {
        LinkedList<ShardingSphereTable> alteredTables = new LinkedList<ShardingSphereTable>();
        LinkedList<String> droppedTables = new LinkedList<String>();
        for (RenameTableDefinitionSegment each : sqlStatement.getRenameTables()) {
            String toBeRenamedTableName = each.getTable().getTableName().getIdentifier().getValue();
            ShardingSphereTable toBeRenamedTable = database.getSchema(schemaName).getTable(toBeRenamedTableName);
            alteredTables.add(new ShardingSphereTable(each.getRenameTable().getTableName().getIdentifier().getValue(), toBeRenamedTable.getAllColumns(), toBeRenamedTable.getAllIndexes(), toBeRenamedTable.getAllConstraints()));
            droppedTables.add(toBeRenamedTableName);
        }
        metaDataManagerPersistService.alterTables(database, schemaName, alteredTables);
        metaDataManagerPersistService.dropTables(database, schemaName, droppedTables);
    }

    @Override
    public Class<RenameTableStatement> getType() {
        return RenameTableStatement.class;
    }
}

