/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.pushdown.type.table;

import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilder;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.GenericSchemaBuilderMaterial;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.mode.metadata.refresher.pushdown.PushDownMetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.util.TableRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;

public final class AlterTablePushDownMetaDataRefresher
implements PushDownMetaDataRefresher<AlterTableStatement> {
    @Override
    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, String logicDataSourceName, String schemaName, DatabaseType databaseType, AlterTableStatement sqlStatement, ConfigurationProperties props) throws SQLException {
        String tableName = TableRefreshUtils.getTableName(sqlStatement.getTable().getTableName().getIdentifier(), databaseType);
        LinkedList<ShardingSphereTable> alteredTables = new LinkedList<ShardingSphereTable>();
        LinkedList<String> droppedTables = new LinkedList<String>();
        if (sqlStatement.getRenameTable().isPresent()) {
            String renameTable = ((SimpleTableSegment)sqlStatement.getRenameTable().get()).getTableName().getIdentifier().getValue();
            alteredTables.add(this.getTable(database, logicDataSourceName, schemaName, renameTable, props));
            droppedTables.add(tableName);
        } else {
            alteredTables.add(this.getTable(database, logicDataSourceName, schemaName, tableName, props));
        }
        metaDataManagerPersistService.alterTables(database, schemaName, alteredTables);
        metaDataManagerPersistService.dropTables(database, schemaName, droppedTables);
    }

    private ShardingSphereTable getTable(ShardingSphereDatabase database, String logicDataSourceName, String schemaName, String tableName, ConfigurationProperties props) throws SQLException {
        RuleMetaData ruleMetaData = new RuleMetaData(new LinkedList(database.getRuleMetaData().getRules()));
        if (TableRefreshUtils.isSingleTable(tableName, database)) {
            ruleMetaData.getAttributes(MutableDataNodeRuleAttribute.class).forEach(each -> each.put(logicDataSourceName, schemaName, tableName));
        }
        GenericSchemaBuilderMaterial material = new GenericSchemaBuilderMaterial(database.getResourceMetaData().getStorageUnits(), ruleMetaData.getRules(), props, schemaName);
        Map schemas = GenericSchemaBuilder.build(Collections.singletonList(tableName), (DatabaseType)database.getProtocolType(), (GenericSchemaBuilderMaterial)material);
        return Optional.ofNullable((ShardingSphereSchema)schemas.get(schemaName)).map(optional -> optional.getTable(tableName)).orElseGet(() -> new ShardingSphereTable(tableName, Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
    }

    @Override
    public Class<AlterTableStatement> getType() {
        return AlterTableStatement.class;
    }
}

