/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.metadata.refresher.pushdown;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.resource.unit.StorageUnit;
import org.apache.shardingsphere.infra.route.context.RouteUnit;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.mode.metadata.refresher.pushdown.PushDownMetaDataRefresher;
import org.apache.shardingsphere.mode.metadata.refresher.util.SchemaRefreshUtils;
import org.apache.shardingsphere.mode.persist.service.MetaDataManagerPersistService;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.AlterIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.CreateIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.index.DropIndexStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.AlterSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.CreateSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.schema.DropSchemaStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.AlterTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.CreateTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.DropTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.table.RenameTableStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.CreateViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.ddl.view.DropViewStatement;

public final class PushDownMetaDataRefreshEngine {
    private static final Collection<Class<?>> SUPPORTED_REFRESH_TYPES = new HashSet<Class>(Arrays.asList(CreateViewStatement.class, AlterViewStatement.class, DropViewStatement.class, CreateIndexStatement.class, AlterIndexStatement.class, DropIndexStatement.class, CreateSchemaStatement.class, AlterSchemaStatement.class, DropSchemaStatement.class, CreateTableStatement.class, AlterTableStatement.class, DropTableStatement.class, RenameTableStatement.class));
    private final SQLStatementContext sqlStatementContext;

    public boolean isNeedRefresh() {
        return SUPPORTED_REFRESH_TYPES.contains(this.sqlStatementContext.getSqlStatement().getClass());
    }

    public void refresh(MetaDataManagerPersistService metaDataManagerPersistService, ShardingSphereDatabase database, ConfigurationProperties props, Collection<RouteUnit> routeUnits) throws SQLException {
        Optional<PushDownMetaDataRefresher> refresher = this.findPushDownMetaDataRefresher(this.sqlStatementContext);
        if (!refresher.isPresent()) {
            return;
        }
        Collection logicDataSourceNames = routeUnits.stream().map(each -> each.getDataSourceMapper().getLogicName()).collect(Collectors.toList());
        String schemaName = SchemaRefreshUtils.getSchemaName(database, this.sqlStatementContext);
        DatabaseType databaseType = routeUnits.stream().map(each -> (StorageUnit)database.getResourceMetaData().getStorageUnits().get(each.getDataSourceMapper().getActualName())).filter(Objects::nonNull).findFirst().map(StorageUnit::getStorageType).orElseGet(() -> this.sqlStatementContext.getSqlStatement().getDatabaseType());
        refresher.get().refresh(metaDataManagerPersistService, database, logicDataSourceNames.isEmpty() ? null : (String)logicDataSourceNames.iterator().next(), schemaName, databaseType, this.sqlStatementContext.getSqlStatement(), props);
    }

    private Optional<PushDownMetaDataRefresher> findPushDownMetaDataRefresher(SQLStatementContext sqlStatementContext) {
        Optional refresher = TypedSPILoader.findService(PushDownMetaDataRefresher.class, sqlStatementContext.getSqlStatement().getClass());
        return refresher.isPresent() ? refresher : TypedSPILoader.findService(PushDownMetaDataRefresher.class, sqlStatementContext.getSqlStatement().getClass().getSuperclass());
    }

    @Generated
    public PushDownMetaDataRefreshEngine(SQLStatementContext sqlStatementContext) {
        this.sqlStatementContext = sqlStatementContext;
    }
}

