/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.exception.mysql.mapper;

import java.sql.SQLException;
import org.apache.shardingsphere.database.exception.core.exception.SQLDialectException;
import org.apache.shardingsphere.database.exception.core.exception.connection.AccessDeniedException;
import org.apache.shardingsphere.database.exception.core.exception.connection.TooManyConnectionsException;
import org.apache.shardingsphere.database.exception.core.exception.data.InsertColumnsAndValuesMismatchedException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.DatabaseCreateExistsException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.DatabaseDropNotExistsException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.NoDatabaseSelectedException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.database.UnknownDatabaseException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.sql.DialectSQLParsingException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.table.NoSuchTableException;
import org.apache.shardingsphere.database.exception.core.exception.syntax.table.TableExistsException;
import org.apache.shardingsphere.database.exception.core.exception.transaction.TableModifyInTransactionException;
import org.apache.shardingsphere.database.exception.core.mapper.SQLDialectExceptionMapper;
import org.apache.shardingsphere.database.exception.mysql.exception.DatabaseAccessDeniedException;
import org.apache.shardingsphere.database.exception.mysql.exception.ErrorGlobalVariableException;
import org.apache.shardingsphere.database.exception.mysql.exception.ErrorLocalVariableException;
import org.apache.shardingsphere.database.exception.mysql.exception.HandshakeException;
import org.apache.shardingsphere.database.exception.mysql.exception.IncorrectGlobalLocalVariableException;
import org.apache.shardingsphere.database.exception.mysql.exception.TooManyPlaceholdersException;
import org.apache.shardingsphere.database.exception.mysql.exception.UnknownCharsetException;
import org.apache.shardingsphere.database.exception.mysql.exception.UnknownCollationException;
import org.apache.shardingsphere.database.exception.mysql.exception.UnknownSystemVariableException;
import org.apache.shardingsphere.database.exception.mysql.exception.UnsupportedPreparedStatementException;
import org.apache.shardingsphere.database.exception.mysql.vendor.MySQLVendorError;
import org.apache.shardingsphere.infra.exception.external.sql.vendor.VendorError;
import org.apache.shardingsphere.infra.exception.generic.UnknownSQLException;

public final class MySQLDialectExceptionMapper
implements SQLDialectExceptionMapper {
    public SQLException convert(SQLDialectException sqlDialectException) {
        if (sqlDialectException instanceof UnknownDatabaseException) {
            return null != ((UnknownDatabaseException)sqlDialectException).getDatabaseName() ? this.toSQLException(MySQLVendorError.ER_BAD_DB_ERROR, ((UnknownDatabaseException)sqlDialectException).getDatabaseName()) : this.toSQLException(MySQLVendorError.ER_NO_DB_ERROR, new Object[0]);
        }
        if (sqlDialectException instanceof NoDatabaseSelectedException) {
            return this.toSQLException(MySQLVendorError.ER_NO_DB_ERROR, new Object[0]);
        }
        if (sqlDialectException instanceof DatabaseCreateExistsException) {
            return this.toSQLException(MySQLVendorError.ER_DB_CREATE_EXISTS_ERROR, ((DatabaseCreateExistsException)sqlDialectException).getDatabaseName());
        }
        if (sqlDialectException instanceof DatabaseDropNotExistsException) {
            return this.toSQLException(MySQLVendorError.ER_DB_DROP_NOT_EXISTS_ERROR, ((DatabaseDropNotExistsException)sqlDialectException).getDatabaseName());
        }
        if (sqlDialectException instanceof TableExistsException) {
            return this.toSQLException(MySQLVendorError.ER_TABLE_EXISTS_ERROR, ((TableExistsException)sqlDialectException).getTableName());
        }
        if (sqlDialectException instanceof DialectSQLParsingException) {
            return this.toSQLException(MySQLVendorError.ER_PARSE_ERROR, sqlDialectException.getMessage(), ((DialectSQLParsingException)sqlDialectException).getSymbol(), ((DialectSQLParsingException)sqlDialectException).getLine());
        }
        if (sqlDialectException instanceof NoSuchTableException) {
            return this.toSQLException(MySQLVendorError.ER_NO_SUCH_TABLE, ((NoSuchTableException)sqlDialectException).getTableName());
        }
        if (sqlDialectException instanceof InsertColumnsAndValuesMismatchedException) {
            return this.toSQLException(MySQLVendorError.ER_WRONG_VALUE_COUNT_ON_ROW, ((InsertColumnsAndValuesMismatchedException)sqlDialectException).getMismatchedRowNumber());
        }
        if (sqlDialectException instanceof TableModifyInTransactionException) {
            return this.toSQLException(MySQLVendorError.ER_ERROR_ON_MODIFYING_GTID_EXECUTED_TABLE, ((TableModifyInTransactionException)sqlDialectException).getTableName());
        }
        if (sqlDialectException instanceof TooManyConnectionsException) {
            return this.toSQLException(MySQLVendorError.ER_CON_COUNT_ERROR, new Object[0]);
        }
        if (sqlDialectException instanceof UnsupportedPreparedStatementException) {
            return this.toSQLException(MySQLVendorError.ER_UNSUPPORTED_PS, new Object[0]);
        }
        if (sqlDialectException instanceof TooManyPlaceholdersException) {
            return this.toSQLException(MySQLVendorError.ER_PS_MANY_PARAM, new Object[0]);
        }
        if (sqlDialectException instanceof UnknownCharsetException) {
            return this.toSQLException(MySQLVendorError.ER_UNKNOWN_CHARACTER_SET, ((UnknownCharsetException)sqlDialectException).getCharset());
        }
        if (sqlDialectException instanceof UnknownCollationException) {
            return this.toSQLException(MySQLVendorError.ER_UNKNOWN_COLLATION, ((UnknownCollationException)sqlDialectException).getCollationId());
        }
        if (sqlDialectException instanceof HandshakeException) {
            return this.toSQLException(MySQLVendorError.ER_HANDSHAKE_ERROR, new Object[0]);
        }
        if (sqlDialectException instanceof AccessDeniedException) {
            AccessDeniedException ex = (AccessDeniedException)sqlDialectException;
            return this.toSQLException(MySQLVendorError.ER_ACCESS_DENIED_ERROR, ex.getUsername(), ex.getHostname(), ex.isUsingPassword() ? "YES" : "NO");
        }
        if (sqlDialectException instanceof DatabaseAccessDeniedException) {
            DatabaseAccessDeniedException ex = (DatabaseAccessDeniedException)sqlDialectException;
            return this.toSQLException(MySQLVendorError.ER_DBACCESS_DENIED_ERROR, ex.getUsername(), ex.getHostname(), ex.getDatabaseName());
        }
        if (sqlDialectException instanceof UnknownSystemVariableException) {
            return this.toSQLException(MySQLVendorError.ER_UNKNOWN_SYSTEM_VARIABLE, ((UnknownSystemVariableException)sqlDialectException).getVariableName());
        }
        if (sqlDialectException instanceof ErrorLocalVariableException) {
            return this.toSQLException(MySQLVendorError.ER_LOCAL_VARIABLE, ((ErrorLocalVariableException)sqlDialectException).getVariableName());
        }
        if (sqlDialectException instanceof ErrorGlobalVariableException) {
            return this.toSQLException(MySQLVendorError.ER_GLOBAL_VARIABLE, ((ErrorGlobalVariableException)sqlDialectException).getVariableName());
        }
        if (sqlDialectException instanceof IncorrectGlobalLocalVariableException) {
            IncorrectGlobalLocalVariableException ex = (IncorrectGlobalLocalVariableException)sqlDialectException;
            return this.toSQLException(MySQLVendorError.ER_INCORRECT_GLOBAL_LOCAL_VAR, ex.getVariableName(), ex.getScope());
        }
        return new UnknownSQLException((Exception)sqlDialectException).toSQLException();
    }

    private SQLException toSQLException(VendorError vendorError, Object ... messageArgs) {
        return new SQLException(String.format(vendorError.getReason(), messageArgs), vendorError.getSqlState().getValue(), vendorError.getVendorCode());
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

