/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment;

import com.google.common.base.Strings;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.DialectDatabaseMetaData;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;

public final class PipelineSQLSegmentBuilder {
    private final DatabaseTypeRegistry databaseTypeRegistry;
    private final DialectDatabaseMetaData dialectDatabaseMetaData;

    public PipelineSQLSegmentBuilder(DatabaseType databaseType) {
        this.databaseTypeRegistry = new DatabaseTypeRegistry(databaseType);
        this.dialectDatabaseMetaData = this.databaseTypeRegistry.getDialectDatabaseMetaData();
    }

    public String getEscapedIdentifier(String identifier) {
        return "*".equals(identifier) ? identifier : this.dialectDatabaseMetaData.getQuoteCharacter().wrap(this.databaseTypeRegistry.formatIdentifierPattern(identifier));
    }

    public String getQualifiedTableName(String schemaName, String tableName) {
        StringBuilder result = new StringBuilder();
        if (this.dialectDatabaseMetaData.getSchemaOption().isSchemaAvailable() && !Strings.isNullOrEmpty((String)schemaName)) {
            result.append(this.getEscapedIdentifier(schemaName)).append('.');
        }
        result.append(this.getEscapedIdentifier(tableName));
        return result.toString();
    }

    public String getQualifiedTableName(QualifiedTable qualifiedTable) {
        return this.getQualifiedTableName(qualifiedTable.getSchemaName(), qualifiedTable.getTableName());
    }
}

