/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.spi.PipelineDataSourceCreator;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.datasource.pool.destroyer.DataSourcePoolDestroyer;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineDataSource
implements DataSource,
AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineDataSource.class);
    private final DataSource dataSource;
    private final DatabaseType databaseType;
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public PipelineDataSource(PipelineDataSourceConfiguration pipelineDataSourceConfig) {
        this.dataSource = ((PipelineDataSourceCreator)TypedSPILoader.getService(PipelineDataSourceCreator.class, (Object)pipelineDataSourceConfig.getType())).create(pipelineDataSourceConfig.getDataSourceConfiguration());
        this.databaseType = pipelineDataSourceConfig.getDatabaseType();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.dataSource.getConnection(username, password);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.dataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.dataSource.isWrapperFor(iface);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.dataSource.setLogWriter(out);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.dataSource.getLoginTimeout();
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.dataSource.setLoginTimeout(seconds);
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return this.dataSource.getParentLogger();
    }

    @Override
    public void close() {
        if (this.closed.get()) {
            return;
        }
        if (!(this.dataSource instanceof AutoCloseable)) {
            log.warn("Data source is not closed, it might cause connection leak, data source: {}", (Object)this.dataSource);
            return;
        }
        new DataSourcePoolDestroyer(this.dataSource).asyncDestroy();
        this.closed.set(true);
    }

    @Generated
    public PipelineDataSource(DataSource dataSource, DatabaseType databaseType) {
        this.dataSource = dataSource;
        this.databaseType = databaseType;
    }

    @Generated
    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

