/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.database.protocol.mysql.packet.binlog;

import lombok.Generated;
import org.apache.shardingsphere.database.protocol.mysql.packet.MySQLPacket;
import org.apache.shardingsphere.database.protocol.mysql.payload.MySQLPacketPayload;

public final class MySQLBinlogEventHeader
extends MySQLPacket {
    public static final int MYSQL_BINLOG_EVENT_HEADER_LENGTH = 19;
    private final int timestamp;
    private final int eventType;
    private final int serverId;
    private final int eventSize;
    private final int logPos;
    private final int flags;
    private final int checksumLength;

    public MySQLBinlogEventHeader(MySQLPacketPayload payload, int checksumLength) {
        this.timestamp = payload.readInt4();
        this.eventType = payload.readInt1();
        this.serverId = payload.readInt4();
        this.eventSize = payload.readInt4();
        this.logPos = payload.readInt4();
        this.flags = payload.readInt2();
        this.checksumLength = checksumLength;
    }

    @Override
    protected void write(MySQLPacketPayload payload) {
        payload.writeInt4(this.timestamp);
        payload.writeInt1(this.eventType);
        payload.writeInt4(this.serverId);
        payload.writeInt4(this.eventSize);
        payload.writeInt4(this.logPos);
        payload.writeInt2(this.flags);
    }

    @Generated
    public MySQLBinlogEventHeader(int timestamp, int eventType, int serverId, int eventSize, int logPos, int flags, int checksumLength) {
        this.timestamp = timestamp;
        this.eventType = eventType;
        this.serverId = serverId;
        this.eventSize = eventSize;
        this.logPos = logPos;
        this.flags = flags;
        this.checksumLength = checksumLength;
    }

    @Generated
    public int getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public int getEventType() {
        return this.eventType;
    }

    @Generated
    public int getServerId() {
        return this.serverId;
    }

    @Generated
    public int getEventSize() {
        return this.eventSize;
    }

    @Generated
    public int getLogPos() {
        return this.logPos;
    }

    @Generated
    public int getFlags() {
        return this.flags;
    }

    @Generated
    public int getChecksumLength() {
        return this.checksumLength;
    }

    @Generated
    public String toString() {
        return "MySQLBinlogEventHeader(timestamp=" + this.getTimestamp() + ", eventType=" + this.getEventType() + ", serverId=" + this.getServerId() + ", eventSize=" + this.getEventSize() + ", logPos=" + this.getLogPos() + ", flags=" + this.getFlags() + ", checksumLength=" + this.getChecksumLength() + ")";
    }
}

