/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.opengauss.ingest.incremental.wal;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.postgresql.ingest.incremental.wal.decode.BaseLogSequenceNumber;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionProperties;
import org.apache.shardingsphere.database.connector.core.jdbcurl.parser.ConnectionPropertiesParser;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.opengauss.PGProperty;
import org.opengauss.jdbc.PgConnection;
import org.opengauss.replication.LogSequenceNumber;
import org.opengauss.replication.PGReplicationStream;
import org.opengauss.replication.fluent.logical.ChainedLogicalStreamBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenGaussLogicalReplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenGaussLogicalReplication.class);
    private static final String HA_PORT_ERROR_MESSAGE_KEY = "HA port";
    private final DatabaseType databaseType = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"openGauss");

    public Connection createConnection(StandardPipelineDataSourceConfiguration pipelineDataSourceConfig) throws SQLException {
        Properties props = new Properties();
        PGProperty.USER.set(props, pipelineDataSourceConfig.getUsername());
        PGProperty.PASSWORD.set(props, pipelineDataSourceConfig.getPassword());
        PGProperty.ASSUME_MIN_SERVER_VERSION.set(props, "9.4");
        PGProperty.REPLICATION.set(props, "database");
        PGProperty.PREFER_QUERY_MODE.set(props, "simple");
        try {
            return DriverManager.getConnection(pipelineDataSourceConfig.getUrl(), props);
        }
        catch (SQLException ex) {
            if (this.failedBecauseOfNonHAPort(ex)) {
                log.info("Failed to connect to openGauss caused by: {} - {}. Try connecting to HA port.", (Object)ex.getSQLState(), (Object)ex.getMessage());
                return this.tryConnectingToHAPort(pipelineDataSourceConfig.getUrl(), props);
            }
            throw ex;
        }
    }

    private boolean failedBecauseOfNonHAPort(SQLException ex) {
        return ex.getMessage().contains(HA_PORT_ERROR_MESSAGE_KEY);
    }

    private Connection tryConnectingToHAPort(String jdbcUrl, Properties props) throws SQLException {
        ConnectionProperties connectionProps = ((ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)this.databaseType)).parse(jdbcUrl, null, null);
        PGProperty.PG_HOST.set(props, connectionProps.getHostname());
        PGProperty.PG_DBNAME.set(props, connectionProps.getCatalog());
        PGProperty.PG_PORT.set(props, connectionProps.getPort() + 1);
        return DriverManager.getConnection((String)this.databaseType.getJdbcUrlPrefixes().iterator().next(), props);
    }

    public PGReplicationStream createReplicationStream(PgConnection connection, BaseLogSequenceNumber startPosition, String slotName, int majorVersion) throws SQLException {
        ChainedLogicalStreamBuilder logicalStreamBuilder = (ChainedLogicalStreamBuilder)((ChainedLogicalStreamBuilder)connection.getReplicationAPI().replicationStream().logical().withSlotName(slotName)).withSlotOption("include-xids", true).withSlotOption("skip-empty-xacts", true).withStartPosition((LogSequenceNumber)startPosition.get());
        if (majorVersion < 3) {
            return logicalStreamBuilder.start();
        }
        return logicalStreamBuilder.withSlotOption("parallel-decode-num", 10).withSlotOption("decode-style", "j").withSlotOption("sending-batch", 0).start();
    }
}

