/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.driver.jdbc.core.resultset;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.driver.jdbc.adapter.AbstractResultSetAdapter;
import org.apache.shardingsphere.driver.jdbc.core.resultset.ShardingSphereResultSetUtils;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.exception.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.driver.jdbc.type.util.ResultSetUtils;
import org.apache.shardingsphere.infra.merge.result.MergedResult;

public final class ShardingSphereResultSet
extends AbstractResultSetAdapter {
    private static final String ASCII = "Ascii";
    private static final String UNICODE = "Unicode";
    private static final String BINARY = "Binary";
    private final MergedResult mergeResultSet;
    private final Map<String, Integer> columnLabelAndIndexMap;

    public ShardingSphereResultSet(List<ResultSet> resultSets, MergedResult mergeResultSet, Statement statement, SQLStatementContext sqlStatementContext) throws SQLException {
        super(resultSets, statement, sqlStatementContext);
        this.mergeResultSet = mergeResultSet;
        this.columnLabelAndIndexMap = ShardingSphereResultSetUtils.createColumnLabelAndIndexMap(sqlStatementContext, resultSets.get(0).getMetaData());
    }

    public ShardingSphereResultSet(List<ResultSet> resultSets, MergedResult mergeResultSet, Statement statement, SQLStatementContext sqlStatementContext, Map<String, Integer> columnLabelAndIndexMap) {
        super(resultSets, statement, sqlStatementContext);
        this.mergeResultSet = mergeResultSet;
        this.columnLabelAndIndexMap = columnLabelAndIndexMap;
    }

    @Override
    public boolean next() throws SQLException {
        return this.mergeResultSet.next();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.mergeResultSet.wasNull();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return (Boolean)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Boolean.TYPE), Boolean.TYPE);
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return (Byte)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Byte.TYPE), Byte.TYPE);
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return (Short)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Short.TYPE), Short.TYPE);
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return (Integer)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Integer.TYPE), Integer.TYPE);
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return (Long)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Long.TYPE), Long.TYPE);
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return ((Float)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Float.TYPE), Float.TYPE)).floatValue();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return (Double)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Double.TYPE), Double.TYPE);
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return (String)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, String.class), String.class);
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return (BigDecimal)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return (BigDecimal)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, BigDecimal.class), BigDecimal.class);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return (byte[])ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, byte[].class), byte[].class);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return (Date)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Date.class), Date.class);
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return (Date)ResultSetUtils.convertValue((Object)this.mergeResultSet.getCalendarValue(columnIndex, Date.class, cal), Date.class);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getDate(this.getIndexFromColumnLabelAndIndexMap(columnLabel), cal);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return (Time)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Time.class), Time.class);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return (Time)ResultSetUtils.convertValue((Object)this.mergeResultSet.getCalendarValue(columnIndex, Time.class, cal), Time.class);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getTime(this.getIndexFromColumnLabelAndIndexMap(columnLabel), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return (Timestamp)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Timestamp.class), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return (Timestamp)ResultSetUtils.convertValue((Object)this.mergeResultSet.getCalendarValue(columnIndex, Timestamp.class, cal), Timestamp.class);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getTimestamp(this.getIndexFromColumnLabelAndIndexMap(columnLabel), cal);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.mergeResultSet.getInputStream(columnIndex, ASCII);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAsciiStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.mergeResultSet.getInputStream(columnIndex, UNICODE);
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getUnicodeStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.mergeResultSet.getInputStream(columnIndex, BINARY);
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.mergeResultSet.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return (Blob)this.mergeResultSet.getValue(columnIndex, Blob.class);
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getBlob(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return (Clob)this.mergeResultSet.getValue(columnIndex, Clob.class);
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getClob(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return (Array)this.mergeResultSet.getValue(columnIndex, Array.class);
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getArray(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return (URL)this.mergeResultSet.getValue(columnIndex, URL.class);
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getURL(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return (SQLXML)this.mergeResultSet.getValue(columnIndex, SQLXML.class);
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.mergeResultSet.getValue(columnIndex, Object.class);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.getIndexFromColumnLabelAndIndexMap(columnLabel));
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        if (BigInteger.class.equals(type)) {
            return (T)BigInteger.valueOf(this.getLong(columnIndex));
        }
        if (Blob.class.equals(type)) {
            return (T)this.getBlob(columnIndex);
        }
        if (Clob.class.equals(type)) {
            return (T)this.getClob(columnIndex);
        }
        if (LocalDateTime.class.equals(type) || LocalDate.class.equals(type) || LocalTime.class.equals(type) || OffsetDateTime.class.equals(type)) {
            return (T)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, Timestamp.class), type);
        }
        return (T)ResultSetUtils.convertValue((Object)this.mergeResultSet.getValue(columnIndex, type), type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getObject((int)this.getIndexFromColumnLabelAndIndexMap(columnLabel), type);
    }

    private Integer getIndexFromColumnLabelAndIndexMap(String columnLabel) throws SQLException {
        Integer result = this.columnLabelAndIndexMap.get(columnLabel);
        ShardingSpherePreconditions.checkNotNull((Object)result, () -> new SQLFeatureNotSupportedException(String.format("Can not get index from column label `%s`.", columnLabel)));
        return result;
    }

    @Generated
    public Map<String, Integer> getColumnLabelAndIndexMap() {
        return this.columnLabelAndIndexMap;
    }
}

