/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.single.decider;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dal.ExplainStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.type.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.rule.RuleMetaData;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedTable;
import org.apache.shardingsphere.infra.rule.attribute.datanode.MutableDataNodeRuleAttribute;
import org.apache.shardingsphere.single.rule.SingleRule;
import org.apache.shardingsphere.sql.parser.statement.core.enums.JoinType;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.JoinTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.type.dml.SelectStatement;
import org.apache.shardingsphere.sqlfederation.spi.SQLFederationDecider;

public final class SingleSQLFederationDecider
implements SQLFederationDecider<SingleRule> {
    public boolean decide(SQLStatementContext sqlStatementContext, List<Object> parameters, RuleMetaData globalRuleMetaData, ShardingSphereDatabase database, SingleRule rule, Collection<DataNode> includedDataNodes) {
        if (sqlStatementContext instanceof SelectStatementContext) {
            return this.decide0(sqlStatementContext, database, rule, includedDataNodes);
        }
        if (sqlStatementContext instanceof ExplainStatementContext) {
            ExplainStatementContext explainStatementContext = (ExplainStatementContext)sqlStatementContext;
            return this.decide(explainStatementContext.getExplainableSQLStatementContext(), parameters, globalRuleMetaData, database, rule, includedDataNodes);
        }
        throw new UnsupportedSQLOperationException(String.format("unsupported SQL statement %s in sql federation", sqlStatementContext.getSqlStatement().getClass().getSimpleName()));
    }

    private boolean decide0(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database, SingleRule rule, Collection<DataNode> includedDataNodes) {
        Collection<QualifiedTable> singleTables = this.getSingleTables(sqlStatementContext, database, rule);
        if (singleTables.isEmpty()) {
            return false;
        }
        if (this.containsView(database, singleTables)) {
            return true;
        }
        if (!includedDataNodes.isEmpty() && !this.isInnerCommaJoin(sqlStatementContext.getSqlStatement())) {
            return true;
        }
        boolean result = rule.isAllTablesInSameComputeNode(includedDataNodes, singleTables);
        includedDataNodes.addAll(this.getTableDataNodes(rule, singleTables));
        return !result;
    }

    private boolean isInnerCommaJoin(SQLStatement sqlStatement) {
        SelectStatement selectStatement = (SelectStatement)sqlStatement;
        if (!selectStatement.getFrom().isPresent() || !(selectStatement.getFrom().get() instanceof JoinTableSegment)) {
            return true;
        }
        JoinTableSegment joinTableSegment = (JoinTableSegment)selectStatement.getFrom().get();
        return JoinType.INNER.name().equalsIgnoreCase(joinTableSegment.getJoinType()) || JoinType.COMMA.name().equalsIgnoreCase(joinTableSegment.getJoinType());
    }

    private Collection<QualifiedTable> getSingleTables(SQLStatementContext sqlStatementContext, ShardingSphereDatabase database, SingleRule rule) {
        Collection<QualifiedTable> qualifiedTables = rule.getQualifiedTables(sqlStatementContext, database);
        return rule.getSingleTables(qualifiedTables);
    }

    private boolean containsView(ShardingSphereDatabase database, Collection<QualifiedTable> singleTables) {
        for (QualifiedTable each : singleTables) {
            if (!database.getSchema(each.getSchemaName()).containsView(each.getTableName())) continue;
            return true;
        }
        return false;
    }

    private Collection<DataNode> getTableDataNodes(SingleRule rule, Collection<QualifiedTable> singleTables) {
        HashSet<DataNode> result = new HashSet<DataNode>(singleTables.size(), 1.0f);
        for (QualifiedTable each : singleTables) {
            ((MutableDataNodeRuleAttribute)rule.getAttributes().getAttribute(MutableDataNodeRuleAttribute.class)).findTableDataNode(each.getSchemaName(), each.getTableName()).ifPresent(result::add);
        }
        return result;
    }

    public int getOrder() {
        return 5;
    }

    public Class<SingleRule> getTypeClass() {
        return SingleRule.class;
    }
}

