/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.transaction.xa.jta.datasource;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;
import lombok.Generated;
import org.apache.shardingsphere.database.connector.core.metadata.database.metadata.option.transaction.DialectTransactionOption;
import org.apache.shardingsphere.database.connector.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.database.connector.core.type.DatabaseType;
import org.apache.shardingsphere.database.connector.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.util.reflection.ReflectionUtils;
import org.apache.shardingsphere.transaction.xa.jta.connection.XAConnectionWrapper;
import org.apache.shardingsphere.transaction.xa.jta.datasource.swapper.DataSourceSwapper;
import org.apache.shardingsphere.transaction.xa.spi.SingleXAResource;
import org.apache.shardingsphere.transaction.xa.spi.XATransactionManagerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XATransactionDataSource
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XATransactionDataSource.class);
    private static final Set<String> CONTAINER_DATASOURCE_NAMES = new HashSet<String>(Arrays.asList("AtomikosDataSourceBean", "BasicManagedDataSource"));
    private final ThreadLocal<Map<Transaction, Collection<Connection>>> enlistedTransactions = ThreadLocal.withInitial(HashMap::new);
    private final ThreadLocal<AtomicInteger> uniqueName = ThreadLocal.withInitial(AtomicInteger::new);
    private final String resourceName;
    private final DataSource dataSource;
    private XADataSource xaDataSource;
    private XAConnectionWrapper xaConnectionWrapper;
    private XATransactionManagerProvider xaTransactionManagerProvider;

    public XATransactionDataSource(DatabaseType databaseType, String resourceName, DataSource dataSource, XATransactionManagerProvider xaTransactionManagerProvider) {
        this.resourceName = resourceName;
        this.dataSource = dataSource;
        if (!CONTAINER_DATASOURCE_NAMES.contains(dataSource.getClass().getSimpleName())) {
            DialectTransactionOption transactionOption = new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getTransactionOption();
            this.xaDataSource = new DataSourceSwapper(databaseType, transactionOption.getXaDriverClassNames()).swap(dataSource);
            this.xaConnectionWrapper = (XAConnectionWrapper)DatabaseTypedSPILoader.getService(XAConnectionWrapper.class, (DatabaseType)databaseType);
            this.xaTransactionManagerProvider = xaTransactionManagerProvider;
            xaTransactionManagerProvider.registerRecoveryResource(resourceName, this.xaDataSource);
        }
    }

    public Connection getConnection() throws SQLException, SystemException, RollbackException {
        if (CONTAINER_DATASOURCE_NAMES.contains(this.dataSource.getClass().getSimpleName())) {
            return this.dataSource.getConnection();
        }
        Transaction transaction = this.xaTransactionManagerProvider.getTransactionManager().getTransaction();
        Connection connection = this.dataSource.getConnection();
        try {
            this.enlistResource(connection, transaction);
        }
        catch (RuntimeException | RollbackException | SystemException ex) {
            this.closeConnection(connection);
            throw ex;
        }
        catch (Exception ex) {
            this.closeConnection(connection);
            throw new SQLException(ex);
        }
        return connection;
    }

    private void enlistResource(Connection connection, Transaction transaction) throws SQLException, RollbackException, SystemException {
        XAConnection xaConnection = this.xaConnectionWrapper.wrap(this.xaDataSource, connection);
        transaction.enlistResource((XAResource)new SingleXAResource(this.resourceName, String.valueOf(this.uniqueName.get().getAndIncrement()), xaConnection.getXAResource()));
        this.registerSynchronization(transaction);
        this.enlistedTransactions.get().computeIfAbsent(transaction, key -> new LinkedList());
        this.enlistedTransactions.get().get(transaction).add(connection);
    }

    private void closeConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (Throwable ex) {
            log.warn("Failed to close connection after enlist failure. Resource: {}", (Object)this.resourceName, (Object)ex);
        }
    }

    private void registerSynchronization(final Transaction transaction) throws RollbackException, SystemException {
        transaction.registerSynchronization(new Synchronization(){

            public void beforeCompletion() {
                ((Map)XATransactionDataSource.this.enlistedTransactions.get()).remove(transaction);
                XATransactionDataSource.this.uniqueName.remove();
            }

            public void afterCompletion(int status) {
                ((Map)XATransactionDataSource.this.enlistedTransactions.get()).clear();
            }
        });
    }

    @Override
    public void close() {
        if (CONTAINER_DATASOURCE_NAMES.contains(this.dataSource.getClass().getSimpleName())) {
            this.close(this.dataSource);
        } else {
            this.xaTransactionManagerProvider.removeRecoveryResource(this.resourceName, this.xaDataSource);
        }
        this.enlistedTransactions.remove();
    }

    private void close(DataSource dataSource) {
        try {
            ReflectionUtils.invokeMethod((Method)dataSource.getClass().getDeclaredMethod("close", new Class[0]), (Object)dataSource, (Object[])new Object[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
    }
}

