/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.global;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereRowData;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.dispatch.handler.DataChangedEventHandler;
import org.apache.shardingsphere.mode.metadata.manager.ShardingSphereDatabaseDataManager;
import org.apache.shardingsphere.mode.node.path.metadata.ShardingSphereDataNodePath;

public final class ShardingSphereDataChangedHandler
implements DataChangedEventHandler {
    @Override
    public String getSubscribedKey() {
        return ShardingSphereDataNodePath.getDatabasesRootPath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public void handle(ContextManager contextManager, DataChangedEvent event) {
        ShardingSphereDatabaseDataManager databaseManager = contextManager.getMetaDataContextManager().getDatabaseManager();
        Optional databaseName = ShardingSphereDataNodePath.findDatabaseName((String)event.getKey(), (boolean)false);
        if (databaseName.isPresent()) {
            this.handleDatabaseChanged(databaseManager, event.getType(), (String)databaseName.get());
            return;
        }
        databaseName = ShardingSphereDataNodePath.findDatabaseName((String)event.getKey(), (boolean)true);
        if (!databaseName.isPresent()) {
            return;
        }
        Optional schemaName = ShardingSphereDataNodePath.findSchemaName((String)event.getKey(), (boolean)false);
        if (schemaName.isPresent()) {
            this.handleSchemaChanged(databaseManager, event.getType(), (String)databaseName.get(), (String)schemaName.get());
            return;
        }
        schemaName = ShardingSphereDataNodePath.findSchemaName((String)event.getKey(), (boolean)true);
        if (!schemaName.isPresent()) {
            return;
        }
        Optional tableName = ShardingSphereDataNodePath.findTableName((String)event.getKey(), (boolean)false);
        if (tableName.isPresent()) {
            this.handleTableChanged(databaseManager, event.getType(), (String)databaseName.get(), (String)schemaName.get(), (String)tableName.get());
            return;
        }
        tableName = ShardingSphereDataNodePath.findTableName((String)event.getKey(), (boolean)true);
        if (!tableName.isPresent()) {
            return;
        }
        Optional uniqueKey = ShardingSphereDataNodePath.findRowUniqueKey((String)event.getKey());
        if (uniqueKey.isPresent()) {
            this.handleRowDataChanged(databaseManager, event.getType(), event.getValue(), (String)databaseName.get(), (String)schemaName.get(), (String)tableName.get(), (String)uniqueKey.get());
        }
    }

    private void handleDatabaseChanged(ShardingSphereDatabaseDataManager databaseManager, DataChangedEvent.Type type, String databaseName) {
        switch (type) {
            case ADDED: 
            case UPDATED: {
                databaseManager.addShardingSphereDatabaseData(databaseName);
                return;
            }
            case DELETED: {
                databaseManager.dropShardingSphereDatabaseData(databaseName);
                return;
            }
        }
    }

    private void handleSchemaChanged(ShardingSphereDatabaseDataManager databaseManager, DataChangedEvent.Type type, String databaseName, String schemaName) {
        switch (type) {
            case ADDED: 
            case UPDATED: {
                databaseManager.addShardingSphereSchemaData(databaseName, schemaName);
                return;
            }
            case DELETED: {
                databaseManager.dropShardingSphereSchemaData(databaseName, schemaName);
                return;
            }
        }
    }

    private void handleTableChanged(ShardingSphereDatabaseDataManager databaseManager, DataChangedEvent.Type type, String databaseName, String schemaName, String tableName) {
        switch (type) {
            case ADDED: 
            case UPDATED: {
                databaseManager.addShardingSphereTableData(databaseName, schemaName, tableName);
                return;
            }
            case DELETED: {
                databaseManager.dropShardingSphereTableData(databaseName, schemaName, tableName);
                return;
            }
        }
    }

    private void handleRowDataChanged(ShardingSphereDatabaseDataManager databaseManager, DataChangedEvent.Type type, String eventValue, String databaseName, String schemaName, String tableName, String uniqueKey) {
        if (!(DataChangedEvent.Type.ADDED != type && DataChangedEvent.Type.UPDATED != type || Strings.isNullOrEmpty((String)eventValue))) {
            databaseManager.alterShardingSphereRowData(databaseName, schemaName, tableName, (YamlShardingSphereRowData)YamlEngine.unmarshal((String)eventValue, YamlShardingSphereRowData.class));
        } else if (DataChangedEvent.Type.DELETED == type) {
            databaseManager.deleteShardingSphereRowData(databaseName, schemaName, tableName, uniqueKey);
        }
    }
}

