/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.context.statement.ddl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.table.TablesContext;
import org.apache.shardingsphere.infra.binder.context.statement.CommonSQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.sql.parser.statement.core.enums.SubqueryType;
import org.apache.shardingsphere.sql.parser.statement.core.extractor.TableExtractor;
import org.apache.shardingsphere.sql.parser.statement.core.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.AlterViewStatement;
import org.apache.shardingsphere.sql.parser.statement.core.statement.dml.SelectStatement;

public final class AlterViewStatementContext
extends CommonSQLStatementContext
implements TableAvailable {
    private final TablesContext tablesContext;
    private final SelectStatementContext selectStatementContext;

    public AlterViewStatementContext(ShardingSphereMetaData metaData, List<Object> params, AlterViewStatement sqlStatement, String currentDatabaseName) {
        super((SQLStatement)sqlStatement);
        LinkedList<SimpleTableSegment> tables = new LinkedList<SimpleTableSegment>();
        tables.add(sqlStatement.getView());
        Optional selectStatement = sqlStatement.getSelect();
        selectStatement.ifPresent(optional -> this.extractTables((SelectStatement)optional, (Collection<SimpleTableSegment>)tables));
        sqlStatement.getRenameView().ifPresent(tables::add);
        this.tablesContext = new TablesContext(tables);
        this.selectStatementContext = selectStatement.map(optional -> this.createSelectStatementContext(metaData, params, (SelectStatement)optional, currentDatabaseName)).orElse(null);
    }

    private SelectStatementContext createSelectStatementContext(ShardingSphereMetaData metaData, List<Object> params, SelectStatement selectStatement, String currentDatabaseName) {
        SelectStatementContext result = new SelectStatementContext(metaData, params, selectStatement, currentDatabaseName, Collections.emptyList());
        result.setSubqueryType(SubqueryType.VIEW_DEFINITION);
        return result;
    }

    private void extractTables(SelectStatement selectStatement, Collection<SimpleTableSegment> tables) {
        TableExtractor extractor = new TableExtractor();
        extractor.extractTablesFromSelect(selectStatement);
        tables.addAll(extractor.getRewriteTables());
    }

    public Optional<SelectStatementContext> getSelectStatementContext() {
        return Optional.ofNullable(this.selectStatementContext);
    }

    public AlterViewStatement getSqlStatement() {
        return (AlterViewStatement)super.getSqlStatement();
    }

    @Override
    @Generated
    public TablesContext getTablesContext() {
        return this.tablesContext;
    }
}

