/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.util;

import lombok.Generated;
import org.apache.shardingsphere.infra.session.connection.transaction.TransactionConnectionContext;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.sql.parser.statement.core.enums.TransactionIsolationLevel;
import org.apache.shardingsphere.transaction.api.TransactionType;
import org.apache.shardingsphere.transaction.rule.TransactionRule;

public final class TransactionUtils {
    public static int getTransactionIsolationLevel(TransactionIsolationLevel isolationLevel) {
        switch (isolationLevel) {
            case READ_UNCOMMITTED: {
                return 1;
            }
            case READ_COMMITTED: {
                return 2;
            }
            case REPEATABLE_READ: {
                return 4;
            }
            case SERIALIZABLE: {
                return 8;
            }
        }
        return 0;
    }

    public static TransactionIsolationLevel getTransactionIsolationLevel(int isolationLevel) {
        switch (isolationLevel) {
            case 1: {
                return TransactionIsolationLevel.READ_UNCOMMITTED;
            }
            case 2: {
                return TransactionIsolationLevel.READ_COMMITTED;
            }
            case 4: {
                return TransactionIsolationLevel.REPEATABLE_READ;
            }
            case 8: {
                return TransactionIsolationLevel.SERIALIZABLE;
            }
        }
        return TransactionIsolationLevel.NONE;
    }

    public static TransactionType getTransactionType(TransactionConnectionContext transactionContext) {
        if (transactionContext.getTransactionType().isPresent()) {
            return TransactionType.valueOf((String)((String)transactionContext.getTransactionType().get()));
        }
        return ((TransactionRule)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getSingleRule(TransactionRule.class)).getDefaultType();
    }

    @Generated
    private TransactionUtils() {
    }
}

