/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.distsql.handler.enums;

import java.util.Arrays;
import java.util.Collection;
import org.apache.shardingsphere.infra.exception.generic.UnsupportedSQLOperationException;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.HintShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.NoneShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;

public enum ShardingStrategyType {
    STANDARD{

        @Override
        public ShardingStrategyConfiguration createConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new StandardShardingStrategyConfiguration(shardingColumn, shardingAlgorithmName);
        }

        @Override
        public Class<? extends ShardingStrategyConfiguration> getImplementedClass() {
            return StandardShardingStrategyConfiguration.class;
        }

        @Override
        public Collection<String> getConfigurationContents(ShardingStrategyConfiguration strategyConfig) {
            return Arrays.asList(((StandardShardingStrategyConfiguration)strategyConfig).getShardingColumn(), strategyConfig.getShardingAlgorithmName());
        }

        @Override
        public boolean isValid(String shardingColumn) {
            return null != shardingColumn && !shardingColumn.contains(",");
        }
    }
    ,
    NONE{

        @Override
        public ShardingStrategyConfiguration createConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new NoneShardingStrategyConfiguration();
        }

        @Override
        public Class<? extends ShardingStrategyConfiguration> getImplementedClass() {
            return NoneShardingStrategyConfiguration.class;
        }

        @Override
        public Collection<String> getConfigurationContents(ShardingStrategyConfiguration strategyConfig) {
            return Arrays.asList("", strategyConfig.getShardingAlgorithmName());
        }

        @Override
        public boolean isValid(String shardingColumn) {
            return true;
        }
    }
    ,
    HINT{

        @Override
        public ShardingStrategyConfiguration createConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new HintShardingStrategyConfiguration(shardingAlgorithmName);
        }

        @Override
        public Class<? extends ShardingStrategyConfiguration> getImplementedClass() {
            return HintShardingStrategyConfiguration.class;
        }

        @Override
        public Collection<String> getConfigurationContents(ShardingStrategyConfiguration strategyConfig) {
            return Arrays.asList("", strategyConfig.getShardingAlgorithmName());
        }

        @Override
        public boolean isValid(String shardingColumn) {
            return null == shardingColumn;
        }
    }
    ,
    COMPLEX{

        @Override
        public ShardingStrategyConfiguration createConfiguration(String shardingAlgorithmName, String shardingColumn) {
            return new ComplexShardingStrategyConfiguration(shardingColumn, shardingAlgorithmName);
        }

        @Override
        public Class<? extends ShardingStrategyConfiguration> getImplementedClass() {
            return ComplexShardingStrategyConfiguration.class;
        }

        @Override
        public Collection<String> getConfigurationContents(ShardingStrategyConfiguration strategyConfig) {
            return Arrays.asList(((ComplexShardingStrategyConfiguration)strategyConfig).getShardingColumns(), strategyConfig.getShardingAlgorithmName());
        }

        @Override
        public boolean isValid(String shardingColumn) {
            return null != shardingColumn && shardingColumn.split(",").length > 1;
        }
    };


    public abstract ShardingStrategyConfiguration createConfiguration(String var1, String var2);

    public abstract Class<? extends ShardingStrategyConfiguration> getImplementedClass();

    public abstract Collection<String> getConfigurationContents(ShardingStrategyConfiguration var1);

    public abstract boolean isValid(String var1);

    public static ShardingStrategyType getValueOf(String name) {
        try {
            return ShardingStrategyType.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException ignored) {
            throw new UnsupportedSQLOperationException(String.format("unsupported strategy type `%s`", name));
        }
    }

    public static ShardingStrategyType getValueOf(ShardingStrategyConfiguration config) {
        return Arrays.stream(ShardingStrategyType.values()).filter(each -> config.getClass().isAssignableFrom(each.getImplementedClass())).findFirst().orElseThrow(() -> new UnsupportedOperationException(String.format("unsupported strategy type: `%s`.", config.getClass().getName())));
    }

    public static boolean isValidType(String type) {
        return Arrays.stream(ShardingStrategyType.values()).map(Enum::name).anyMatch(each -> each.equalsIgnoreCase(type));
    }
}

