/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.metrics;

import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import org.apache.shardingsphere.shade.io.opentelemetry.api.internal.Utils;
import org.apache.shardingsphere.shade.io.opentelemetry.api.metrics.MeterProvider;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.compression.Compressor;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.compression.CompressorUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.http.HttpExporterBuilder;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.otlp.internal.OtlpUserAgent;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.MemoryMode;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.ProxyOptions;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.common.export.RetryPolicy;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;

public final class OtlpHttpMetricExporterBuilder {
    private static final String DEFAULT_ENDPOINT = "http://localhost:4318/v1/metrics";
    private static final AggregationTemporalitySelector DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR = AggregationTemporalitySelector.alwaysCumulative();
    private static final MemoryMode DEFAULT_MEMORY_MODE = MemoryMode.IMMUTABLE_DATA;
    private final HttpExporterBuilder<Marshaler> delegate;
    private AggregationTemporalitySelector aggregationTemporalitySelector = DEFAULT_AGGREGATION_TEMPORALITY_SELECTOR;
    private DefaultAggregationSelector defaultAggregationSelector = DefaultAggregationSelector.getDefault();
    private MemoryMode memoryMode;

    OtlpHttpMetricExporterBuilder(HttpExporterBuilder<Marshaler> delegate, MemoryMode memoryMode) {
        this.delegate = delegate;
        this.memoryMode = memoryMode;
        delegate.setMeterProvider(MeterProvider::noop);
        OtlpUserAgent.addUserAgentHeader(delegate::addConstantHeaders);
    }

    OtlpHttpMetricExporterBuilder() {
        this(new HttpExporterBuilder<Marshaler>("otlp", "metric", DEFAULT_ENDPOINT), DEFAULT_MEMORY_MODE);
    }

    public OtlpHttpMetricExporterBuilder setTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setTimeout(timeout2, unit);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        return this.setTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpMetricExporterBuilder setConnectTimeout(long timeout2, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument(timeout2 >= 0L, "timeout must be non-negative");
        this.delegate.setConnectTimeout(timeout2, unit);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setConnectTimeout(Duration timeout2) {
        Objects.requireNonNull(timeout2, "timeout");
        return this.setConnectTimeout(timeout2.toNanos(), TimeUnit.NANOSECONDS);
    }

    public OtlpHttpMetricExporterBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.delegate.setEndpoint(endpoint);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setCompression(String compressionMethod) {
        Objects.requireNonNull(compressionMethod, "compressionMethod");
        Compressor compressor = CompressorUtil.validateAndResolveCompressor(compressionMethod);
        this.delegate.setCompression(compressor);
        return this;
    }

    public OtlpHttpMetricExporterBuilder addHeader(String key, String value) {
        this.delegate.addConstantHeaders(key, value);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setHeaders(Supplier<Map<String, String>> headerSupplier) {
        this.delegate.setHeadersSupplier(headerSupplier);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        this.delegate.setTrustManagerFromCerts(trustedCertificatesPem);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        this.delegate.setKeyManagerFromCerts(privateKeyPem, certificatePem);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setSslContext(SSLContext sslContext, X509TrustManager trustManager) {
        this.delegate.setSslContext(sslContext, trustManager);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setAggregationTemporalitySelector(AggregationTemporalitySelector aggregationTemporalitySelector) {
        Objects.requireNonNull(aggregationTemporalitySelector, "aggregationTemporalitySelector");
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        return this;
    }

    public OtlpHttpMetricExporterBuilder setDefaultAggregationSelector(DefaultAggregationSelector defaultAggregationSelector) {
        Objects.requireNonNull(defaultAggregationSelector, "defaultAggregationSelector");
        this.defaultAggregationSelector = defaultAggregationSelector;
        return this;
    }

    public OtlpHttpMetricExporterBuilder setRetryPolicy(@Nullable RetryPolicy retryPolicy) {
        this.delegate.setRetryPolicy(retryPolicy);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setProxyOptions(ProxyOptions proxyOptions) {
        Objects.requireNonNull(proxyOptions, "proxyOptions");
        this.delegate.setProxyOptions(proxyOptions);
        return this;
    }

    public OtlpHttpMetricExporterBuilder setMemoryMode(MemoryMode memoryMode) {
        Objects.requireNonNull(memoryMode, "memoryMode");
        this.memoryMode = memoryMode;
        return this;
    }

    OtlpHttpMetricExporterBuilder exportAsJson() {
        this.delegate.exportAsJson();
        return this;
    }

    public OtlpHttpMetricExporter build() {
        return new OtlpHttpMetricExporter(this.delegate, this.delegate.build(), this.aggregationTemporalitySelector, this.defaultAggregationSelector, this.memoryMode);
    }
}

