/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.readwritesplitting.rule.changed;

import com.google.common.base.Strings;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.spi.rule.RuleItemConfigurationChangedProcessor;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.alter.AlterRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropNamedRuleItem;
import org.apache.shardingsphere.mode.spi.rule.item.drop.DropRuleItem;
import org.apache.shardingsphere.readwritesplitting.config.ReadwriteSplittingRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.config.rule.ReadwriteSplittingDataSourceGroupRuleConfiguration;
import org.apache.shardingsphere.readwritesplitting.rule.ReadwriteSplittingRule;
import org.apache.shardingsphere.readwritesplitting.transaction.TransactionalReadQueryStrategy;
import org.apache.shardingsphere.readwritesplitting.yaml.config.rule.YamlReadwriteSplittingDataSourceGroupRuleConfiguration;

public final class ReadwriteSplittingDataSourceChangedProcessor
implements RuleItemConfigurationChangedProcessor<ReadwriteSplittingRuleConfiguration, ReadwriteSplittingDataSourceGroupRuleConfiguration> {
    public ReadwriteSplittingDataSourceGroupRuleConfiguration swapRuleItemConfiguration(AlterRuleItem alterRuleItem, String yamlContent) {
        YamlReadwriteSplittingDataSourceGroupRuleConfiguration yamlDataSourceGroupRuleConfig = (YamlReadwriteSplittingDataSourceGroupRuleConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlReadwriteSplittingDataSourceGroupRuleConfiguration.class);
        return new ReadwriteSplittingDataSourceGroupRuleConfiguration(((AlterNamedRuleItem)alterRuleItem).getItemName(), yamlDataSourceGroupRuleConfig.getWriteDataSourceName(), yamlDataSourceGroupRuleConfig.getReadDataSourceNames(), this.getTransactionalReadQueryStrategy(yamlDataSourceGroupRuleConfig), yamlDataSourceGroupRuleConfig.getLoadBalancerName());
    }

    private TransactionalReadQueryStrategy getTransactionalReadQueryStrategy(YamlReadwriteSplittingDataSourceGroupRuleConfiguration yamlDataSourceGroupRuleConfig) {
        return Strings.isNullOrEmpty((String)yamlDataSourceGroupRuleConfig.getTransactionalReadQueryStrategy()) ? TransactionalReadQueryStrategy.DYNAMIC : TransactionalReadQueryStrategy.valueOf((String)yamlDataSourceGroupRuleConfig.getTransactionalReadQueryStrategy());
    }

    public ReadwriteSplittingRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(ReadwriteSplittingRule.class).map(ReadwriteSplittingRule::getConfiguration).orElseGet(() -> new ReadwriteSplittingRuleConfiguration(new LinkedList(), new LinkedHashMap()));
    }

    public void changeRuleItemConfiguration(AlterRuleItem alterRuleItem, ReadwriteSplittingRuleConfiguration currentRuleConfig, ReadwriteSplittingDataSourceGroupRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getDataSourceGroups().removeIf(each -> each.getName().equals(toBeChangedItemConfig.getName()));
        currentRuleConfig.getDataSourceGroups().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItem dropRuleItem, ReadwriteSplittingRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getDataSourceGroups().removeIf(each -> each.getName().equals(((DropNamedRuleItem)dropRuleItem).getItemName()));
    }

    public String getType() {
        return "readwrite_splitting.data_source_groups";
    }
}

