/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.rule.checker;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.datanode.DataNode;
import org.apache.shardingsphere.infra.datanode.DataNodeInfo;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.sharding.algorithm.sharding.inline.InlineShardingAlgorithm;
import org.apache.shardingsphere.sharding.api.config.ShardingRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.rule.ShardingTableReferenceRuleConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ComplexShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.ShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.config.strategy.sharding.StandardShardingStrategyConfiguration;
import org.apache.shardingsphere.sharding.api.sharding.standard.PreciseShardingValue;
import org.apache.shardingsphere.sharding.exception.metadata.DuplicateShardingActualDataNodeException;
import org.apache.shardingsphere.sharding.exception.metadata.InvalidBindingTablesException;
import org.apache.shardingsphere.sharding.exception.metadata.ShardingTableRuleNotFoundException;
import org.apache.shardingsphere.sharding.rule.BindingTableCheckedConfiguration;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sharding.rule.ShardingTable;
import org.apache.shardingsphere.sharding.spi.ShardingAlgorithm;

public class ShardingRuleChecker {
    private final ShardingRule shardingRule;

    public void check(ShardingRuleConfiguration ruleConfig) {
        this.checkUniqueActualDataNodesInTableRules();
        this.checkBindingTableConfiguration(ruleConfig);
        this.checkInlineShardingAlgorithmsInTableRules();
    }

    private void checkUniqueActualDataNodesInTableRules() {
        HashSet uniqueActualDataNodes = new HashSet(this.shardingRule.getShardingTables().size(), 1.0f);
        this.shardingRule.getShardingTables().forEach((key, value) -> this.checkUniqueActualDataNodes(uniqueActualDataNodes, (String)key, value.getActualDataNodes().iterator().next()));
    }

    private void checkUniqueActualDataNodes(Collection<DataNode> uniqueActualDataNodes, String logicTable, DataNode sampleActualDataNode) {
        ShardingSpherePreconditions.checkNotContains(uniqueActualDataNodes, (Object)sampleActualDataNode, () -> new DuplicateShardingActualDataNodeException(logicTable, sampleActualDataNode.getDataSourceName(), sampleActualDataNode.getTableName()));
        uniqueActualDataNodes.add(sampleActualDataNode);
    }

    private void checkBindingTableConfiguration(ShardingRuleConfiguration ruleConfig) {
        ShardingSpherePreconditions.checkState((boolean)this.isValidBindingTableConfiguration(this.shardingRule.getShardingTables(), new BindingTableCheckedConfiguration(this.shardingRule.getDataSourceNames(), this.shardingRule.getShardingAlgorithms(), ruleConfig.getBindingTableGroups(), this.shardingRule.getDefaultDatabaseShardingStrategyConfig(), this.shardingRule.getDefaultTableShardingStrategyConfig(), this.shardingRule.getDefaultShardingColumn())), InvalidBindingTablesException::new);
    }

    private boolean isValidBindingTableConfiguration(Map<String, ShardingTable> shardingTables, BindingTableCheckedConfiguration checkedConfig) {
        for (ShardingTableReferenceRuleConfiguration each : checkedConfig.getBindingTableGroups()) {
            List bindingTables = Splitter.on((String)",").trimResults().splitToList((CharSequence)each.getReference());
            if (bindingTables.size() <= 1) continue;
            Iterator iterator = bindingTables.iterator();
            ShardingTable sampleShardingTable = this.getShardingTable((String)iterator.next(), shardingTables);
            while (iterator.hasNext()) {
                ShardingTable shardingTable = this.getShardingTable((String)iterator.next(), shardingTables);
                if (!this.isValidActualDataSourceName(sampleShardingTable, shardingTable) || !this.isValidActualTableName(sampleShardingTable, shardingTable)) {
                    return false;
                }
                if (this.isBindingShardingAlgorithm(sampleShardingTable, shardingTable, true, checkedConfig) && this.isBindingShardingAlgorithm(sampleShardingTable, shardingTable, false, checkedConfig)) continue;
                return false;
            }
        }
        return true;
    }

    private ShardingTable getShardingTable(String logicTableName, Map<String, ShardingTable> shardingTables) {
        ShardingTable result = shardingTables.get(logicTableName);
        ShardingSpherePreconditions.checkNotNull((Object)result, () -> new ShardingTableRuleNotFoundException(Collections.singleton(logicTableName)));
        return result;
    }

    private boolean isValidActualDataSourceName(ShardingTable sampleShardingTable, ShardingTable shardingTable) {
        return sampleShardingTable.getActualDataSourceNames().equals(shardingTable.getActualDataSourceNames());
    }

    private boolean isValidActualTableName(ShardingTable sampleShardingTable, ShardingTable shardingTable) {
        for (String each : sampleShardingTable.getActualDataSourceNames()) {
            Collection actualTableNames;
            Collection sampleActualTableNames = sampleShardingTable.getActualTableNames(each).stream().map(actualTableName -> actualTableName.replace(sampleShardingTable.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet());
            if (sampleActualTableNames.equals(actualTableNames = (Collection)shardingTable.getActualTableNames(each).stream().map(optional -> optional.replace(shardingTable.getTableDataNode().getPrefix(), "")).collect(Collectors.toSet()))) continue;
            return false;
        }
        return true;
    }

    private boolean isBindingShardingAlgorithm(ShardingTable sampleShardingTable, ShardingTable shardingTable, boolean databaseAlgorithm, BindingTableCheckedConfiguration checkedConfig) {
        return this.getAlgorithmExpression(sampleShardingTable, databaseAlgorithm, checkedConfig).equals(this.getAlgorithmExpression(shardingTable, databaseAlgorithm, checkedConfig));
    }

    private Optional<String> getAlgorithmExpression(ShardingTable shardingTable, boolean databaseAlgorithm, BindingTableCheckedConfiguration checkedConfig) {
        ShardingStrategyConfiguration shardingStrategyConfig = databaseAlgorithm ? this.shardingRule.getDatabaseShardingStrategyConfiguration(shardingTable) : this.shardingRule.getTableShardingStrategyConfiguration(shardingTable);
        ShardingAlgorithm shardingAlgorithm = checkedConfig.getShardingAlgorithms().get(shardingStrategyConfig.getShardingAlgorithmName());
        String dataNodePrefix = databaseAlgorithm ? shardingTable.getDataSourceDataNode().getPrefix() : shardingTable.getTableDataNode().getPrefix();
        String shardingColumn = this.getShardingColumn(shardingStrategyConfig, this.shardingRule.getDefaultShardingColumn());
        return null == shardingAlgorithm ? Optional.empty() : shardingAlgorithm.getAlgorithmStructure(dataNodePrefix, shardingColumn);
    }

    private String getShardingColumn(ShardingStrategyConfiguration shardingStrategyConfig, String defaultShardingColumn) {
        String shardingColumn = defaultShardingColumn;
        if (shardingStrategyConfig instanceof ComplexShardingStrategyConfiguration) {
            shardingColumn = ((ComplexShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumns();
        }
        if (shardingStrategyConfig instanceof StandardShardingStrategyConfiguration) {
            shardingColumn = ((StandardShardingStrategyConfiguration)shardingStrategyConfig).getShardingColumn();
        }
        return null == shardingColumn ? "" : shardingColumn;
    }

    private void checkInlineShardingAlgorithmsInTableRules() {
        this.shardingRule.getShardingTables().forEach((key, value) -> {
            this.validateInlineShardingAlgorithm((ShardingTable)value, this.shardingRule.getTableShardingStrategyConfiguration((ShardingTable)value), value.getTableDataNode());
            this.validateInlineShardingAlgorithm((ShardingTable)value, this.shardingRule.getDatabaseShardingStrategyConfiguration((ShardingTable)value), value.getDataSourceDataNode());
        });
    }

    private void validateInlineShardingAlgorithm(ShardingTable shardingTable, ShardingStrategyConfiguration shardingStrategy, DataNodeInfo dataNodeInfo) {
        if (null == shardingStrategy) {
            return;
        }
        ShardingAlgorithm shardingAlgorithm = this.shardingRule.getShardingAlgorithms().get(shardingStrategy.getShardingAlgorithmName());
        if (shardingAlgorithm instanceof InlineShardingAlgorithm) {
            String shardingColumn = null == ((StandardShardingStrategyConfiguration)shardingStrategy).getShardingColumn() ? this.shardingRule.getDefaultShardingColumn() : ((StandardShardingStrategyConfiguration)shardingStrategy).getShardingColumn();
            String result = null;
            try {
                result = ((InlineShardingAlgorithm)shardingAlgorithm).doSharding(Collections.emptySet(), new PreciseShardingValue(shardingTable.getLogicTable(), shardingColumn, dataNodeInfo, (Object)1));
            }
            catch (Exception exception) {
                // empty catch block
            }
            ShardingSpherePreconditions.checkState((null == result || result.startsWith(dataNodeInfo.getPrefix()) ? 1 : 0) != 0, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)shardingAlgorithm, "`%s` sharding algorithm configuration of `%s` does not match the actual data nodes", new Object[]{shardingStrategy.getShardingAlgorithmName(), shardingTable.getLogicTable()}));
        }
    }

    public void checkToBeAddedDataNodes(Map<String, Collection<DataNode>> toBeAddedDataNodes, boolean isAlteration) {
        HashSet uniqueActualDataNodes = new HashSet(this.shardingRule.getShardingTables().size() + toBeAddedDataNodes.size(), 1.0f);
        this.shardingRule.getShardingTables().forEach((key, value) -> {
            if (isAlteration && toBeAddedDataNodes.containsKey(key)) {
                return;
            }
            this.checkUniqueActualDataNodes(uniqueActualDataNodes, (String)key, value.getActualDataNodes().iterator().next());
        });
        toBeAddedDataNodes.forEach((key, value) -> this.checkUniqueActualDataNodes(uniqueActualDataNodes, (String)key, (DataNode)value.iterator().next()));
    }

    @Generated
    public ShardingRuleChecker(ShardingRule shardingRule) {
        this.shardingRule = shardingRule;
    }
}

