/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress.config;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.PipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.yaml.config.YamlPipelineProcessConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.yaml.config.YamlPipelineReadConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.yaml.config.YamlPipelineWriteConfiguration;
import org.apache.shardingsphere.data.pipeline.core.job.progress.config.yaml.swapper.YamlPipelineProcessConfigurationSwapper;
import org.apache.shardingsphere.infra.algorithm.core.yaml.YamlAlgorithmConfiguration;

public final class PipelineProcessConfigurationUtils {
    private static final YamlPipelineProcessConfigurationSwapper SWAPPER = new YamlPipelineProcessConfigurationSwapper();

    public static PipelineProcessConfiguration fillInDefaultValue(PipelineProcessConfiguration originalConfig) {
        YamlPipelineProcessConfiguration yamlConfig = null == originalConfig ? new YamlPipelineProcessConfiguration() : SWAPPER.swapToYamlConfiguration(originalConfig);
        PipelineProcessConfigurationUtils.fillInDefaultValue(yamlConfig);
        return SWAPPER.swapToObject(yamlConfig);
    }

    private static void fillInDefaultValue(YamlPipelineProcessConfiguration yamlConfig) {
        if (null == yamlConfig.getRead()) {
            yamlConfig.setRead(new YamlPipelineReadConfiguration());
        }
        if (null == yamlConfig.getWrite()) {
            yamlConfig.setWrite(new YamlPipelineWriteConfiguration());
        }
        if (null == yamlConfig.getStreamChannel()) {
            YamlAlgorithmConfiguration yamlAlgorithmConfig = new YamlAlgorithmConfiguration();
            yamlAlgorithmConfig.setType("MEMORY");
            Properties props = new Properties();
            props.setProperty("block-queue-size", "2000");
            yamlAlgorithmConfig.setProps(props);
            yamlConfig.setStreamChannel(yamlAlgorithmConfig);
        }
    }

    @Generated
    private PipelineProcessConfigurationUtils() {
    }
}

