/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.initializer;

import java.sql.SQLException;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataBuilder;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.infra.yaml.config.swapper.mode.YamlModeConfigurationSwapper;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.proxy.backend.config.ProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.YamlProxyConfiguration;
import org.apache.shardingsphere.proxy.backend.config.yaml.swapper.YamlProxyConfigurationSwapper;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.version.ShardingSphereProxyVersion;

public final class BootstrapInitializer {
    public void init(YamlProxyConfiguration yamlConfig, int port) throws SQLException {
        ModeConfiguration modeConfig = null == yamlConfig.getServerConfiguration().getMode() ? null : new YamlModeConfigurationSwapper().swapToObject(yamlConfig.getServerConfiguration().getMode());
        ProxyConfiguration proxyConfig = new YamlProxyConfigurationSwapper().swap(yamlConfig);
        ContextManager contextManager = this.createContextManager(proxyConfig, modeConfig, port);
        ProxyContext.init((ContextManager)contextManager);
        ShardingSphereProxyVersion.setVersion(contextManager);
    }

    private ContextManager createContextManager(ProxyConfiguration proxyConfig, ModeConfiguration modeConfig, int port) throws SQLException {
        InstanceMetaData instanceMetaData = ((InstanceMetaDataBuilder)TypedSPILoader.getService(InstanceMetaDataBuilder.class, (Object)"Proxy")).build(port, "");
        ContextManagerBuilderParameter param = new ContextManagerBuilderParameter(modeConfig, proxyConfig.getDatabaseConfigurations(), proxyConfig.getGlobalConfiguration().getDataSources(), proxyConfig.getGlobalConfiguration().getRules(), proxyConfig.getGlobalConfiguration().getProperties(), proxyConfig.getGlobalConfiguration().getLabels(), instanceMetaData);
        return ((ContextManagerBuilder)TypedSPILoader.getService(ContextManagerBuilder.class, (Object)(null == modeConfig ? null : modeConfig.getType()))).build(param, new EventBusContext());
    }
}

