/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.algorithm.cryptographic.aes;

import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.shardingsphere.infra.algorithm.core.ShardingSphereAlgorithm;
import org.apache.shardingsphere.infra.algorithm.core.exception.AlgorithmInitializationException;
import org.apache.shardingsphere.infra.algorithm.cryptographic.core.CryptographicAlgorithm;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;

public final class AESCryptographicAlgorithm
implements CryptographicAlgorithm {
    private static final String AES_KEY = "aes-key-value";
    private static final String DIGEST_ALGORITHM_NAME = "digest-algorithm-name";
    private byte[] secretKey;

    public void init(Properties props) {
        this.secretKey = this.getSecretKey(props);
    }

    private byte[] getSecretKey(Properties props) {
        String aesKey = props.getProperty(AES_KEY);
        ShardingSpherePreconditions.checkNotEmpty((String)aesKey, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "%s can not be null or empty", new Object[]{AES_KEY}));
        String digestAlgorithm = props.getProperty(DIGEST_ALGORITHM_NAME);
        ShardingSpherePreconditions.checkNotEmpty((String)digestAlgorithm, () -> new AlgorithmInitializationException((ShardingSphereAlgorithm)this, "%s can not be null or empty", new Object[]{DIGEST_ALGORITHM_NAME}));
        return Arrays.copyOf(DigestUtils.getDigest((String)digestAlgorithm.toUpperCase()).digest(aesKey.getBytes(StandardCharsets.UTF_8)), 16);
    }

    public String encrypt(Object plainValue) {
        if (null == plainValue) {
            return null;
        }
        byte[] result = this.getCipher(1).doFinal(String.valueOf(plainValue).getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(result);
    }

    public Object decrypt(Object cipherValue) {
        if (null == cipherValue) {
            return null;
        }
        byte[] result = this.getCipher(2).doFinal(Base64.getDecoder().decode(cipherValue.toString().trim()));
        return new String(result, StandardCharsets.UTF_8);
    }

    private Cipher getCipher(int decryptMode) throws GeneralSecurityException {
        Cipher result = Cipher.getInstance(this.getType());
        result.init(decryptMode, new SecretKeySpec(this.secretKey, this.getType()));
        return result;
    }

    public String getType() {
        return "AES";
    }
}

