/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.subscriber.dispatch;

import com.google.common.eventbus.Subscribe;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.eventbus.EventSubscriber;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.DatabaseDataAddedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.DatabaseDataDeletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.SchemaDataAddedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.SchemaDataDeletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.ShardingSphereRowDataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.ShardingSphereRowDataDeletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.metadata.data.TableDataChangedEvent;
import org.apache.shardingsphere.mode.manager.ContextManager;

public final class DatabaseDataChangedSubscriber
implements EventSubscriber {
    private final ContextManager contextManager;

    @Subscribe
    public synchronized void renew(DatabaseDataAddedEvent event) {
        this.contextManager.getMetaDataContextManager().getDatabaseManager().addShardingSphereDatabaseData(event.getDatabaseName());
    }

    @Subscribe
    public synchronized void renew(DatabaseDataDeletedEvent event) {
        this.contextManager.getMetaDataContextManager().getDatabaseManager().dropShardingSphereDatabaseData(event.getDatabaseName());
    }

    @Subscribe
    public synchronized void renew(SchemaDataAddedEvent event) {
        this.contextManager.getMetaDataContextManager().getDatabaseManager().addShardingSphereSchemaData(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(SchemaDataDeletedEvent event) {
        this.contextManager.getMetaDataContextManager().getDatabaseManager().dropShardingSphereSchemaData(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(TableDataChangedEvent event) {
        if (null != event.getAddedTable()) {
            this.contextManager.getMetaDataContextManager().getDatabaseManager().addShardingSphereTableData(event.getDatabaseName(), event.getSchemaName(), event.getAddedTable());
        }
        if (null != event.getDeletedTable()) {
            this.contextManager.getMetaDataContextManager().getDatabaseManager().dropShardingSphereTableData(event.getDatabaseName(), event.getSchemaName(), event.getDeletedTable());
        }
    }

    @Subscribe
    public synchronized void renew(ShardingSphereRowDataChangedEvent event) {
        this.contextManager.getMetaDataContextManager().getDatabaseManager().alterShardingSphereRowData(event.getDatabaseName(), event.getSchemaName(), event.getTableName(), event.getYamlRowData());
    }

    @Subscribe
    public synchronized void renew(ShardingSphereRowDataDeletedEvent event) {
        this.contextManager.getMetaDataContextManager().getDatabaseManager().deleteShardingSphereRowData(event.getDatabaseName(), event.getSchemaName(), event.getTableName(), event.getUniqueKey());
    }

    @Generated
    public DatabaseDataChangedSubscriber(ContextManager contextManager) {
        this.contextManager = contextManager;
    }
}

