/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseTypeAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptConditionsAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.assignment.EncryptInsertAssignmentTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.assignment.EncryptUpdateAssignmentTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.ddl.EncryptAlterTableTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.ddl.EncryptCreateTableTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.insert.EncryptInsertCipherNameTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.insert.EncryptInsertDefaultColumnsTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.insert.EncryptInsertDerivedColumnsTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.insert.EncryptInsertOnUpdateTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.insert.EncryptInsertValuesTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate.EncryptInsertPredicateColumnTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate.EncryptInsertPredicateRightValueTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate.EncryptPredicateColumnTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.predicate.EncryptPredicateRightValueTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.projection.EncryptInsertSelectProjectionTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.projection.EncryptSelectProjectionTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.select.EncryptGroupByItemTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.select.EncryptIndexColumnTokenGenerator;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.SQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.common.generator.builder.SQLTokenGeneratorBuilder;

public final class EncryptTokenGenerateBuilder
implements SQLTokenGeneratorBuilder {
    private final EncryptRule encryptRule;
    private final SQLStatementContext sqlStatementContext;
    private final Collection<EncryptCondition> encryptConditions;
    private final String databaseName;

    public Collection<SQLTokenGenerator> getSQLTokenGenerators() {
        LinkedList<SQLTokenGenerator> result = new LinkedList<SQLTokenGenerator>();
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptSelectProjectionTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertSelectProjectionTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertAssignmentTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptUpdateAssignmentTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptPredicateColumnTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertPredicateColumnTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptPredicateRightValueTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertPredicateRightValueTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertValuesTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertDefaultColumnsTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertCipherNameTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertDerivedColumnsTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptInsertOnUpdateTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptGroupByItemTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptIndexColumnTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptCreateTableTokenGenerator(this.encryptRule));
        this.addSQLTokenGenerator(result, (SQLTokenGenerator)new EncryptAlterTableTokenGenerator(this.encryptRule));
        return result;
    }

    private void addSQLTokenGenerator(Collection<SQLTokenGenerator> sqlTokenGenerators, SQLTokenGenerator toBeAddedSQLTokenGenerator) {
        this.setUpSQLTokenGenerator(toBeAddedSQLTokenGenerator);
        if (toBeAddedSQLTokenGenerator.isGenerateSQLToken(this.sqlStatementContext)) {
            sqlTokenGenerators.add(toBeAddedSQLTokenGenerator);
        }
    }

    private void setUpSQLTokenGenerator(SQLTokenGenerator toBeAddedSQLTokenGenerator) {
        if (toBeAddedSQLTokenGenerator instanceof EncryptConditionsAware) {
            ((EncryptConditionsAware)toBeAddedSQLTokenGenerator).setEncryptConditions(this.encryptConditions);
        }
        if (toBeAddedSQLTokenGenerator instanceof DatabaseNameAware) {
            ((DatabaseNameAware)toBeAddedSQLTokenGenerator).setDatabaseName(this.databaseName);
        }
        if (toBeAddedSQLTokenGenerator instanceof DatabaseTypeAware) {
            ((DatabaseTypeAware)toBeAddedSQLTokenGenerator).setDatabaseType(this.sqlStatementContext.getDatabaseType());
        }
    }

    @Generated
    public EncryptTokenGenerateBuilder(EncryptRule encryptRule, SQLStatementContext sqlStatementContext, Collection<EncryptCondition> encryptConditions, String databaseName) {
        this.encryptRule = encryptRule;
        this.sqlStatementContext = sqlStatementContext;
        this.encryptConditions = encryptConditions;
        this.databaseName = databaseName;
    }
}

