/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job.progress.persist;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineJobItemContext;
import org.apache.shardingsphere.data.pipeline.core.job.PipelineJobRegistry;
import org.apache.shardingsphere.data.pipeline.core.job.id.PipelineJobIdUtils;
import org.apache.shardingsphere.data.pipeline.core.job.progress.persist.PipelineJobProgressPersistContext;
import org.apache.shardingsphere.data.pipeline.core.job.service.PipelineJobItemManager;
import org.apache.shardingsphere.data.pipeline.core.job.type.PipelineJobType;
import org.apache.shardingsphere.infra.exception.core.ShardingSpherePreconditions;
import org.apache.shardingsphere.infra.executor.kernel.thread.ExecutorThreadFactoryBuilder;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobProgressPersistService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobProgressPersistService.class);
    private static final Map<String, Map<Integer, PipelineJobProgressPersistContext>> JOB_PROGRESS_PERSIST_MAP = new ConcurrentHashMap<String, Map<Integer, PipelineJobProgressPersistContext>>();
    private static final ScheduledExecutorService JOB_PERSIST_EXECUTOR = Executors.newSingleThreadScheduledExecutor(ExecutorThreadFactoryBuilder.build((String)"pipeline-progress-persist-%d"));
    private static final long DELAY_SECONDS = 1L;

    public static void add(String jobId, int shardingItem) {
        JOB_PROGRESS_PERSIST_MAP.computeIfAbsent(jobId, key -> new ConcurrentHashMap()).put(shardingItem, new PipelineJobProgressPersistContext(jobId, shardingItem));
    }

    public static void remove(String jobId) {
        JOB_PROGRESS_PERSIST_MAP.remove(jobId);
    }

    public static void notifyPersist(String jobId, int shardingItem) {
        PipelineJobProgressPersistService.getPersistContext(jobId, shardingItem).ifPresent(persistContext -> persistContext.getUnhandledEventCount().incrementAndGet());
    }

    private static Optional<PipelineJobProgressPersistContext> getPersistContext(String jobId, int shardingItem) {
        Map persistContextMap = JOB_PROGRESS_PERSIST_MAP.getOrDefault(jobId, Collections.emptyMap());
        return Optional.ofNullable((PipelineJobProgressPersistContext)persistContextMap.get(shardingItem));
    }

    public static void persistNow(String jobId, int shardingItem) {
        PipelineJobProgressPersistService.getPersistContext(jobId, shardingItem).ifPresent(persistContext -> PersistJobContextRunnable.persist(jobId, shardingItem, persistContext));
    }

    @Generated
    private PipelineJobProgressPersistService() {
    }

    static {
        JOB_PERSIST_EXECUTOR.scheduleWithFixedDelay(new PersistJobContextRunnable(), 0L, 1L, TimeUnit.SECONDS);
    }

    private static final class PersistJobContextRunnable
    implements Runnable {
        private PersistJobContextRunnable() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : JOB_PROGRESS_PERSIST_MAP.entrySet()) {
                ((Map)entry.getValue()).forEach((shardingItem, persistContext) -> PersistJobContextRunnable.persist((String)entry.getKey(), shardingItem, persistContext));
            }
        }

        private static synchronized void persist(String jobId, int shardingItem, PipelineJobProgressPersistContext persistContext) {
            block3: {
                try {
                    PersistJobContextRunnable.persist0(jobId, shardingItem, persistContext);
                }
                catch (RuntimeException ex) {
                    if (!persistContext.getFirstExceptionLogged().get()) {
                        log.error("Persist job progress failed, jobId={}, shardingItem={}", new Object[]{jobId, shardingItem, ex});
                        persistContext.getFirstExceptionLogged().set(true);
                    }
                    if (5 != ThreadLocalRandom.current().nextInt(60)) break block3;
                    log.error("Persist job progress failed, jobId={}, shardingItem={}", new Object[]{jobId, shardingItem, ex});
                }
            }
        }

        private static void persist0(String jobId, int shardingItem, PipelineJobProgressPersistContext persistContext) {
            long currentUnhandledEventCount = persistContext.getUnhandledEventCount().get();
            ShardingSpherePreconditions.checkState((currentUnhandledEventCount >= 0L ? 1 : 0) != 0, () -> new IllegalStateException("Current unhandled event count must be greater than or equal to 0"));
            if (0L == currentUnhandledEventCount) {
                return;
            }
            Optional<PipelineJobItemContext> jobItemContext = PipelineJobRegistry.getItemContext(jobId, shardingItem);
            if (!jobItemContext.isPresent()) {
                return;
            }
            long startTimeMillis = System.currentTimeMillis();
            new PipelineJobItemManager(((PipelineJobType)TypedSPILoader.getService(PipelineJobType.class, (Object)PipelineJobIdUtils.parseJobType(jobId).getType())).getYamlJobItemProgressSwapper()).updateProgress(jobItemContext.get());
            persistContext.getUnhandledEventCount().addAndGet(-currentUnhandledEventCount);
            if (6 == ThreadLocalRandom.current().nextInt(100)) {
                log.info("persist, jobId={}, shardingItem={}, cost {} ms", new Object[]{jobId, shardingItem, System.currentTimeMillis() - startTimeMillis});
            }
        }
    }
}

