/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.type;

import org.apache.shardingsphere.data.pipeline.core.ingest.position.type.pk.PrimaryKeyIngestPosition;

public final class IntegerPrimaryKeyIngestPosition
implements PrimaryKeyIngestPosition<Long> {
    private final long beginValue;
    private final long endValue;

    public IntegerPrimaryKeyIngestPosition(long beginValue, long endValue) {
        this.beginValue = beginValue;
        this.endValue = endValue;
    }

    @Override
    public Long getBeginValue() {
        return this.beginValue;
    }

    @Override
    public Long getEndValue() {
        return this.endValue;
    }

    @Override
    public Long convert(String value) {
        return Long.parseLong(value);
    }

    @Override
    public char getType() {
        return 'i';
    }

    public String toString() {
        return String.format("%s,%s,%s", Character.valueOf(this.getType()), this.beginValue, this.endValue);
    }
}

