/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.result.SingleTableInventoryCalculatedResult;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.AbstractSingleTableInventoryCalculator;
import org.apache.shardingsphere.data.pipeline.core.consistencycheck.table.calculator.SingleTableInventoryCalculateParameter;

public abstract class AbstractStreamingSingleTableInventoryCalculator
extends AbstractSingleTableInventoryCalculator {
    @Override
    public final Iterable<SingleTableInventoryCalculatedResult> calculate(SingleTableInventoryCalculateParameter param) {
        return new ResultIterable(param);
    }

    protected abstract Optional<SingleTableInventoryCalculatedResult> calculateChunk(SingleTableInventoryCalculateParameter var1);

    private final class ResultIterable
    implements Iterable<SingleTableInventoryCalculatedResult> {
        private final SingleTableInventoryCalculateParameter param;

        @Override
        public Iterator<SingleTableInventoryCalculatedResult> iterator() {
            return new ResultIterator(this.param);
        }

        @Generated
        public ResultIterable(SingleTableInventoryCalculateParameter param) {
            this.param = param;
        }
    }

    private final class ResultIterator
    implements Iterator<SingleTableInventoryCalculatedResult> {
        private final AtomicBoolean currentChunkCalculated = new AtomicBoolean();
        private final AtomicReference<Optional<SingleTableInventoryCalculatedResult>> nextResult = new AtomicReference();
        private final SingleTableInventoryCalculateParameter param;

        @Override
        public boolean hasNext() {
            this.calculateIfNecessary();
            return this.nextResult.get().isPresent();
        }

        @Override
        public SingleTableInventoryCalculatedResult next() {
            this.calculateIfNecessary();
            Optional<SingleTableInventoryCalculatedResult> result = this.nextResult.get();
            this.nextResult.set(null);
            this.currentChunkCalculated.set(false);
            return result.orElseThrow(NoSuchElementException::new);
        }

        private void calculateIfNecessary() {
            if (!this.currentChunkCalculated.get()) {
                this.nextResult.set(AbstractStreamingSingleTableInventoryCalculator.this.calculateChunk(this.param));
                this.currentChunkCalculated.set(true);
            }
        }

        @Generated
        public ResultIterator(SingleTableInventoryCalculateParameter param) {
            this.param = param;
        }
    }
}

