/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.sqlbuilder;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.shardingsphere.data.pipeline.core.exception.job.CreateTableSQLGenerateException;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.dialect.DialectPipelineSQLBuilder;
import org.apache.shardingsphere.data.pipeline.core.sqlbuilder.segment.PipelineSQLSegmentBuilder;

public final class MySQLPipelineSQLBuilder
implements DialectPipelineSQLBuilder {
    public Optional<String> buildInsertOnDuplicateClause(DataRecord dataRecord) {
        StringBuilder result = new StringBuilder("ON DUPLICATE KEY UPDATE ");
        PipelineSQLSegmentBuilder sqlSegmentBuilder = new PipelineSQLSegmentBuilder(this.getType());
        for (int i = 0; i < dataRecord.getColumnCount(); ++i) {
            Column column = dataRecord.getColumn(i);
            result.append(sqlSegmentBuilder.getEscapedIdentifier(column.getName())).append("=VALUES(").append(sqlSegmentBuilder.getEscapedIdentifier(column.getName())).append("),");
        }
        result.setLength(result.length() - 1);
        return Optional.of(result.toString());
    }

    public String buildCheckEmptyTableSQL(String qualifiedTableName) {
        return String.format("SELECT * FROM %s LIMIT 1", qualifiedTableName);
    }

    public Optional<String> buildEstimatedCountSQL(String qualifiedTableName) {
        return Optional.of(String.format("SELECT TABLE_ROWS FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = ? AND TABLE_NAME = '%s'", qualifiedTableName));
    }

    public Optional<String> buildCRC32SQL(String qualifiedTableName, String columnName) {
        return Optional.of(String.format("SELECT BIT_XOR(CAST(CRC32(%s) AS UNSIGNED)) AS checksum, COUNT(1) AS cnt FROM %s", columnName, qualifiedTableName));
    }

    public Collection<String> buildCreateTableSQLs(DataSource dataSource, String schemaName, String tableName) throws SQLException {
        try (Connection connection = dataSource.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(String.format("SHOW CREATE TABLE %s", tableName));){
            if (resultSet.next()) {
                Set<String> set = Collections.singleton(resultSet.getString("create table"));
                return set;
            }
        }
        throw new CreateTableSQLGenerateException(tableName);
    }

    public String wrapWithPageQuery(String sql) {
        return sql + " LIMIT ?";
    }

    public String getDatabaseType() {
        return "MySQL";
    }
}

