/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.dumper;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.type.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.core.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.core.constant.PipelineSQLOperationType;
import org.apache.shardingsphere.data.pipeline.core.execute.AbstractPipelineLifecycleRunnable;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumper;
import org.apache.shardingsphere.data.pipeline.core.ingest.dumper.incremental.IncrementalDumperContext;
import org.apache.shardingsphere.data.pipeline.core.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Column;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.DataRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.PlaceholderRecord;
import org.apache.shardingsphere.data.pipeline.core.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineColumnMetaData;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.data.MySQLBinlogDataHandler;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.MySQLBaseBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.rows.MySQLBaseRowsBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.rows.MySQLDeleteRowsBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.rows.MySQLUpdateRowsBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.event.rows.MySQLWriteRowsBinlogEvent;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.binlog.position.MySQLBinlogPosition;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.ConnectInfo;
import org.apache.shardingsphere.data.pipeline.mysql.ingest.incremental.client.MySQLBinlogClient;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionProperties;
import org.apache.shardingsphere.infra.database.core.connector.ConnectionPropertiesParser;
import org.apache.shardingsphere.infra.database.core.spi.DatabaseTypedSPILoader;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.metadata.caseinsensitive.CaseInsensitiveIdentifier;
import org.apache.shardingsphere.infra.spi.type.typed.TypedSPILoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLIncrementalDumper
extends AbstractPipelineLifecycleRunnable
implements IncrementalDumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MySQLIncrementalDumper.class);
    private final IncrementalDumperContext dumperContext;
    private final MySQLBinlogPosition binlogPosition;
    private final PipelineTableMetaDataLoader metaDataLoader;
    private final PipelineChannel channel;
    private final MySQLBinlogClient client;
    private final String catalog;

    public MySQLIncrementalDumper(IncrementalDumperContext dumperContext, IngestPosition binlogPosition, PipelineChannel channel, PipelineTableMetaDataLoader metaDataLoader) {
        this.dumperContext = dumperContext;
        this.binlogPosition = (MySQLBinlogPosition)binlogPosition;
        this.channel = channel;
        this.metaDataLoader = metaDataLoader;
        StandardPipelineDataSourceConfiguration pipelineDataSourceConfig = (StandardPipelineDataSourceConfiguration)dumperContext.getCommonContext().getDataSourceConfig();
        DatabaseType databaseType = (DatabaseType)TypedSPILoader.getService(DatabaseType.class, (Object)"MySQL");
        ConnectionProperties connectionProps = ((ConnectionPropertiesParser)DatabaseTypedSPILoader.getService(ConnectionPropertiesParser.class, (DatabaseType)databaseType)).parse(pipelineDataSourceConfig.getUrl(), null, null);
        ConnectInfo connectInfo = new ConnectInfo(this.generateServerId(), connectionProps.getHostname(), connectionProps.getPort(), pipelineDataSourceConfig.getUsername(), pipelineDataSourceConfig.getPassword());
        log.info("incremental dump, jdbcUrl={}, serverId={}, hostname={}, port={}", new Object[]{pipelineDataSourceConfig.getUrl(), connectInfo.getServerId(), connectInfo.getHost(), connectInfo.getPort()});
        this.client = new MySQLBinlogClient(connectInfo, dumperContext.isDecodeWithTX());
        this.catalog = connectionProps.getCatalog();
    }

    private int generateServerId() {
        int result = ((Object)((Object)this)).hashCode();
        return Integer.MIN_VALUE == result ? Integer.MAX_VALUE : Math.abs(result);
    }

    protected void runBlocking() {
        this.client.connect();
        this.client.subscribe(this.binlogPosition.getFilename(), this.binlogPosition.getPosition());
        while (this.isRunning()) {
            this.handleEvents(this.client.poll());
        }
    }

    private void handleEvents(List<MySQLBaseBinlogEvent> events) {
        LinkedList<? extends Record> dataRecords = new LinkedList<Record>();
        for (MySQLBaseBinlogEvent each : events) {
            dataRecords.addAll(this.handleEvent(each));
        }
        if (!dataRecords.isEmpty()) {
            this.channel.push(dataRecords);
        }
    }

    private List<? extends Record> handleEvent(MySQLBaseBinlogEvent event) {
        if (!(event instanceof MySQLBaseRowsBinlogEvent)) {
            return Collections.singletonList(this.createPlaceholderRecord(event));
        }
        MySQLBaseRowsBinlogEvent rowsEvent = (MySQLBaseRowsBinlogEvent)event;
        if (!rowsEvent.getDatabaseName().equals(this.catalog) || !this.dumperContext.getCommonContext().getTableNameMapper().containsTable(rowsEvent.getTableName())) {
            return Collections.singletonList(this.createPlaceholderRecord(event));
        }
        PipelineTableMetaData tableMetaData = this.getPipelineTableMetaData(rowsEvent.getTableName());
        if (event instanceof MySQLWriteRowsBinlogEvent) {
            return this.handleWriteRowsEvent((MySQLWriteRowsBinlogEvent)event, tableMetaData);
        }
        if (event instanceof MySQLUpdateRowsBinlogEvent) {
            return this.handleUpdateRowsEvent((MySQLUpdateRowsBinlogEvent)event, tableMetaData);
        }
        if (event instanceof MySQLDeleteRowsBinlogEvent) {
            return this.handleDeleteRowsEvent((MySQLDeleteRowsBinlogEvent)event, tableMetaData);
        }
        return Collections.emptyList();
    }

    private PlaceholderRecord createPlaceholderRecord(MySQLBaseBinlogEvent event) {
        PlaceholderRecord result = new PlaceholderRecord((IngestPosition)new MySQLBinlogPosition(event.getFileName(), event.getPosition()));
        result.setCommitTime(event.getTimestamp() * 1000L);
        return result;
    }

    private PipelineTableMetaData getPipelineTableMetaData(String actualTableName) {
        CaseInsensitiveIdentifier logicTableName = this.dumperContext.getCommonContext().getTableNameMapper().getLogicTableName(actualTableName);
        return this.metaDataLoader.getTableMetaData(this.dumperContext.getCommonContext().getTableAndSchemaNameMapper().getSchemaName(logicTableName), actualTableName);
    }

    private List<DataRecord> handleWriteRowsEvent(MySQLWriteRowsBinlogEvent event, PipelineTableMetaData tableMetaData) {
        LinkedList<DataRecord> result = new LinkedList<DataRecord>();
        for (Serializable[] each : event.getAfterRows()) {
            DataRecord dataRecord = this.createDataRecord(PipelineSQLOperationType.INSERT, event, each.length);
            for (int i = 0; i < each.length; ++i) {
                PipelineColumnMetaData columnMetaData = tableMetaData.getColumnMetaData(i + 1);
                dataRecord.addColumn(new Column(columnMetaData.getName(), (Object)MySQLBinlogDataHandler.handle(columnMetaData, each[i]), true, columnMetaData.isUniqueKey()));
            }
            result.add(dataRecord);
        }
        return result;
    }

    private List<DataRecord> handleUpdateRowsEvent(MySQLUpdateRowsBinlogEvent event, PipelineTableMetaData tableMetaData) {
        LinkedList<DataRecord> result = new LinkedList<DataRecord>();
        for (int i = 0; i < event.getBeforeRows().size(); ++i) {
            Serializable[] beforeValues = event.getBeforeRows().get(i);
            Serializable[] afterValues = event.getAfterRows().get(i);
            DataRecord dataRecord = this.createDataRecord(PipelineSQLOperationType.UPDATE, event, beforeValues.length);
            for (int j = 0; j < beforeValues.length; ++j) {
                PipelineColumnMetaData columnMetaData = tableMetaData.getColumnMetaData(j + 1);
                Serializable oldValue = MySQLBinlogDataHandler.handle(columnMetaData, beforeValues[j]);
                Serializable newValue = MySQLBinlogDataHandler.handle(columnMetaData, afterValues[j]);
                boolean updated = !Objects.deepEquals(newValue, oldValue);
                dataRecord.addColumn(new Column(columnMetaData.getName(), (Object)oldValue, (Object)newValue, updated, columnMetaData.isUniqueKey()));
            }
            result.add(dataRecord);
        }
        return result;
    }

    private List<DataRecord> handleDeleteRowsEvent(MySQLDeleteRowsBinlogEvent event, PipelineTableMetaData tableMetaData) {
        LinkedList<DataRecord> result = new LinkedList<DataRecord>();
        for (Serializable[] each : event.getBeforeRows()) {
            DataRecord dataRecord = this.createDataRecord(PipelineSQLOperationType.DELETE, event, each.length);
            int length = each.length;
            for (int i = 0; i < length; ++i) {
                PipelineColumnMetaData columnMetaData = tableMetaData.getColumnMetaData(i + 1);
                dataRecord.addColumn(new Column(columnMetaData.getName(), (Object)MySQLBinlogDataHandler.handle(columnMetaData, each[i]), null, true, columnMetaData.isUniqueKey()));
            }
            result.add(dataRecord);
        }
        return result;
    }

    private DataRecord createDataRecord(PipelineSQLOperationType type, MySQLBaseRowsBinlogEvent rowsEvent, int columnCount) {
        String tableName = this.dumperContext.getCommonContext().getTableNameMapper().getLogicTableName(rowsEvent.getTableName()).toString();
        MySQLBinlogPosition binlogPosition = new MySQLBinlogPosition(rowsEvent.getFileName(), rowsEvent.getPosition());
        DataRecord result = new DataRecord(type, tableName, (IngestPosition)binlogPosition, columnCount);
        result.setActualTableName(rowsEvent.getTableName());
        result.setCommitTime(rowsEvent.getTimestamp() * 1000L);
        return result;
    }

    protected void doStop() {
        if (null != this.client) {
            this.client.closeChannel();
        }
    }
}

