/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.proxy.backend.connector;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.ConnectionMode;
import org.apache.shardingsphere.infra.executor.sql.prepare.driver.DatabaseConnectionManager;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.spi.type.ordered.OrderedSPILoader;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.connection.ConnectionPostProcessor;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.connection.ResourceLock;
import org.apache.shardingsphere.proxy.backend.connector.jdbc.transaction.BackendTransactionManager;
import org.apache.shardingsphere.proxy.backend.context.ProxyContext;
import org.apache.shardingsphere.proxy.backend.exception.BackendConnectionException;
import org.apache.shardingsphere.proxy.backend.handler.ProxyBackendHandler;
import org.apache.shardingsphere.proxy.backend.session.ConnectionSession;
import org.apache.shardingsphere.proxy.backend.util.TransactionUtils;
import org.apache.shardingsphere.transaction.spi.TransactionHook;

public final class ProxyDatabaseConnectionManager
implements DatabaseConnectionManager<Connection> {
    private final ConnectionSession connectionSession;
    private final Multimap<String, Connection> cachedConnections = LinkedHashMultimap.create();
    private final Collection<ProxyBackendHandler> backendHandlers = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final Collection<ProxyBackendHandler> inUseBackendHandlers = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final Collection<ConnectionPostProcessor> connectionPostProcessors = new LinkedList<ConnectionPostProcessor>();
    private final ResourceLock resourceLock = new ResourceLock();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final Map<ShardingSphereRule, TransactionHook> transactionHooks = OrderedSPILoader.getServices(TransactionHook.class, (Collection)ProxyContext.getInstance().getContextManager().getMetaDataContexts().getMetaData().getGlobalRuleMetaData().getRules());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(String databaseName, String dataSourceName, int connectionOffset, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        List<Connection> result;
        Collection connections;
        Preconditions.checkNotNull((Object)databaseName, (Object)"Current database name is null.");
        String cacheKey = this.getKey(databaseName, dataSourceName);
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)cacheKey);
        }
        int maxConnectionSize = connectionOffset + connectionSize;
        if (connections.size() >= maxConnectionSize) {
            result = new ArrayList(connections).subList(connectionOffset, maxConnectionSize);
        } else if (connections.isEmpty()) {
            List<Connection> newConnections = this.createNewConnections(databaseName, dataSourceName, maxConnectionSize, connectionMode);
            result = new ArrayList<Connection>(newConnections).subList(connectionOffset, maxConnectionSize);
            Multimap<String, Connection> multimap2 = this.cachedConnections;
            synchronized (multimap2) {
                this.cachedConnections.putAll((Object)cacheKey, newConnections);
            }
            this.executeTransactionHooksAfterCreateConnections(result);
        } else {
            ArrayList<Connection> allConnections = new ArrayList<Connection>(maxConnectionSize);
            allConnections.addAll(connections);
            List<Connection> newConnections = this.createNewConnections(databaseName, dataSourceName, maxConnectionSize - connections.size(), connectionMode);
            allConnections.addAll(newConnections);
            result = allConnections.subList(connectionOffset, maxConnectionSize);
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)cacheKey, newConnections);
            }
        }
        return result;
    }

    private String getKey(String databaseName, String dataSourceName) {
        return databaseName.toLowerCase() + "." + dataSourceName;
    }

    private void executeTransactionHooksAfterCreateConnections(List<Connection> connections) throws SQLException {
        if (this.connectionSession.getTransactionStatus().isInTransaction()) {
            DatabaseType databaseType = ProxyContext.getInstance().getDatabaseType();
            for (Map.Entry<ShardingSphereRule, TransactionHook> entry : this.transactionHooks.entrySet()) {
                entry.getValue().afterCreateConnections(entry.getKey(), databaseType, connections, this.connectionSession.getConnectionContext().getTransactionContext());
            }
        }
    }

    private List<Connection> createNewConnections(String databaseName, String dataSourceName, int connectionSize, ConnectionMode connectionMode) throws SQLException {
        List<Connection> result = ProxyContext.getInstance().getBackendDataSource().getConnections(databaseName.toLowerCase(), dataSourceName, connectionSize, connectionMode);
        this.setSessionVariablesIfNecessary(result);
        for (Connection each : result) {
            this.replayTransactionOption(each);
        }
        if (this.connectionSession.getTransactionStatus().isInTransaction()) {
            for (Connection each : result) {
                this.replayMethodsInvocation(each);
            }
        }
        return result;
    }

    private void setSessionVariablesIfNecessary(List<Connection> connections) throws SQLException {
        if (this.connectionSession.getRequiredSessionVariableRecorder().isEmpty() || connections.isEmpty()) {
            return;
        }
        String databaseType = connections.iterator().next().getMetaData().getDatabaseProductName();
        List<String> setSQLs = this.connectionSession.getRequiredSessionVariableRecorder().toSetSQLs(databaseType);
        try {
            this.executeSetSessionVariables(connections, setSQLs);
        }
        catch (SQLException ex) {
            this.releaseConnection(connections, ex);
            throw ex;
        }
    }

    private void executeSetSessionVariables(List<Connection> connections, List<String> setSQLs) throws SQLException {
        for (Connection each : connections) {
            Statement statement = each.createStatement();
            try {
                for (String eachSetSQL : setSQLs) {
                    statement.execute(eachSetSQL);
                }
            }
            finally {
                if (statement == null) continue;
                statement.close();
            }
        }
    }

    private void releaseConnection(List<Connection> connections, SQLException sqlException) {
        for (Connection each : connections) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                sqlException.setNextException(ex);
            }
        }
    }

    private void replayMethodsInvocation(Connection target) throws SQLException {
        for (ConnectionPostProcessor each : this.connectionPostProcessors) {
            each.process(target);
        }
    }

    private void replayTransactionOption(Connection connection) throws SQLException {
        if (null == connection) {
            return;
        }
        if (this.connectionSession.isReadOnly()) {
            connection.setReadOnly(true);
        }
        if (this.connectionSession.getIsolationLevel().isPresent()) {
            connection.setTransactionIsolation(TransactionUtils.getTransactionIsolationLevel(this.connectionSession.getIsolationLevel().get()));
        }
    }

    public Collection<String> getUsedDataSourceNames() {
        ArrayList<String> result = new ArrayList<String>(this.cachedConnections.size());
        String databaseName = this.connectionSession.getUsedDatabaseName().toLowerCase();
        for (String each : this.cachedConnections.keySet()) {
            String[] split = each.split("\\.", 2);
            String cachedDatabaseName = split[0];
            String cachedDataSourceName = split[1];
            if (!databaseName.equals(cachedDatabaseName)) continue;
            result.add(cachedDataSourceName);
        }
        return result;
    }

    public int getConnectionSize() {
        return this.cachedConnections.values().size();
    }

    public void add(ProxyBackendHandler handler) {
        this.backendHandlers.add(handler);
    }

    public void markResourceInUse(ProxyBackendHandler handler) {
        this.inUseBackendHandlers.add(handler);
    }

    public void unmarkResourceInUse(ProxyBackendHandler handler) {
        this.inUseBackendHandlers.remove(handler);
    }

    public void handleAutoCommit() {
        if (!this.connectionSession.isAutoCommit() && !this.connectionSession.getTransactionStatus().isInTransaction()) {
            BackendTransactionManager transactionManager = new BackendTransactionManager(this);
            transactionManager.begin();
        }
    }

    public void closeExecutionResources() throws BackendConnectionException {
        ProxyDatabaseConnectionManager proxyDatabaseConnectionManager = this;
        synchronized (proxyDatabaseConnectionManager) {
            LinkedList<Exception> result = new LinkedList<Exception>(this.closeHandlers(false));
            if (!this.connectionSession.getTransactionStatus().isInConnectionHeldTransaction(TransactionUtils.getTransactionType(this.connectionSession.getConnectionContext().getTransactionContext()))) {
                result.addAll(this.closeHandlers(true));
                result.addAll(this.closeConnections(false));
            } else if (this.closed.get()) {
                result.addAll(this.closeHandlers(true));
                result.addAll(this.closeConnections(true));
            }
            if (result.isEmpty()) {
                return;
            }
            throw new BackendConnectionException(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllResources() {
        ProxyDatabaseConnectionManager proxyDatabaseConnectionManager = this;
        synchronized (proxyDatabaseConnectionManager) {
            this.closed.set(true);
            this.closeHandlers(true);
            this.closeConnections(true);
        }
    }

    public Collection<SQLException> closeHandlers(boolean includeInUse) {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (ProxyBackendHandler each : this.backendHandlers) {
            if (!includeInUse && this.inUseBackendHandlers.contains(each)) continue;
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        if (includeInUse) {
            this.inUseBackendHandlers.clear();
        }
        this.backendHandlers.retainAll(this.inUseBackendHandlers);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SQLException> closeConnections(boolean forceRollback) {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            this.resetSessionVariablesIfNecessary(this.cachedConnections.values(), result);
            for (Connection each : this.cachedConnections.values()) {
                try {
                    if (forceRollback && this.connectionSession.getTransactionStatus().isInTransaction()) {
                        each.rollback();
                    }
                    each.close();
                }
                catch (SQLException ex) {
                    result.add(ex);
                }
            }
            this.cachedConnections.clear();
        }
        if (!forceRollback) {
            this.connectionPostProcessors.clear();
        }
        return result;
    }

    private void resetSessionVariablesIfNecessary(Collection<Connection> values, Collection<SQLException> exceptions) {
        String databaseType;
        if (this.connectionSession.getRequiredSessionVariableRecorder().isEmpty() || values.isEmpty()) {
            return;
        }
        try {
            databaseType = values.iterator().next().getMetaData().getDatabaseProductName();
        }
        catch (SQLException ex) {
            exceptions.add(ex);
            return;
        }
        List<String> resetSQLs = this.connectionSession.getRequiredSessionVariableRecorder().toResetSQLs(databaseType);
        for (Connection each : values) {
            try {
                Statement statement = each.createStatement();
                try {
                    for (String eachResetSQL : resetSQLs) {
                        statement.execute(eachResetSQL);
                    }
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            catch (SQLException ex) {
                exceptions.add(ex);
            }
        }
        this.connectionSession.getRequiredSessionVariableRecorder().removeVariablesWithDefaultValue();
    }

    @Generated
    public ProxyDatabaseConnectionManager(ConnectionSession connectionSession) {
        this.connectionSession = connectionSession;
    }

    @Generated
    public ConnectionSession getConnectionSession() {
        return this.connectionSession;
    }

    @Generated
    public Multimap<String, Connection> getCachedConnections() {
        return this.cachedConnections;
    }

    @Generated
    public Collection<ProxyBackendHandler> getBackendHandlers() {
        return this.backendHandlers;
    }

    @Generated
    public Collection<ProxyBackendHandler> getInUseBackendHandlers() {
        return this.inUseBackendHandlers;
    }

    @Generated
    public Collection<ConnectionPostProcessor> getConnectionPostProcessors() {
        return this.connectionPostProcessors;
    }

    @Generated
    public ResourceLock getResourceLock() {
        return this.resourceLock;
    }

    @Generated
    public AtomicBoolean getClosed() {
        return this.closed;
    }

    @Generated
    public Map<ShardingSphereRule, TransactionHook> getTransactionHooks() {
        return this.transactionHooks;
    }
}

