/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.connection.ShardingDDLRouteException;
import org.apache.shardingsphere.sharding.exception.metadata.IndexNotExistedException;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.segment.ddl.index.IndexSegment;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.DropIndexStatement;

public final class ShardingDropIndexStatementValidator
extends ShardingDDLStatementValidator {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props) {
        DropIndexStatement dropIndexStatement = (DropIndexStatement)sqlStatementContext.getSqlStatement();
        if (dropIndexStatement.isIfExists()) {
            return;
        }
        String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
        for (IndexSegment each : dropIndexStatement.getIndexes()) {
            ShardingSphereSchema schema = each.getOwner().map(optional -> optional.getIdentifier().getValue()).map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchemaName));
            if (this.isSchemaContainsIndex(schema, each)) continue;
            throw new IndexNotExistedException(each.getIndexName().getIdentifier().getValue());
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        DropIndexStatement dropIndexStatement = (DropIndexStatement)sqlStatementContext.getSqlStatement();
        Collection indexSegments = dropIndexStatement.getIndexes();
        Optional<String> logicTableName = dropIndexStatement.getSimpleTable().map(optional -> optional.getTableName().getIdentifier().getValue());
        if (logicTableName.isPresent()) {
            this.validateDropIndexRouteUnit(shardingRule, routeContext, indexSegments, logicTableName.get());
        } else {
            String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
            for (IndexSegment each : indexSegments) {
                ShardingSphereSchema schema = each.getOwner().map(optional -> optional.getIdentifier().getValue()).map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchemaName));
                logicTableName = schema.getAllTableNames().stream().filter(tableName -> schema.getTable(tableName).containsIndex(each.getIndexName().getIdentifier().getValue())).findFirst();
                logicTableName.ifPresent(optional -> this.validateDropIndexRouteUnit(shardingRule, routeContext, indexSegments, (String)optional));
            }
        }
    }

    private void validateDropIndexRouteUnit(ShardingRule shardingRule, RouteContext routeContext, Collection<IndexSegment> indexSegments, String logicTableName) {
        if (this.isRouteUnitDataNodeDifferentSize(shardingRule, routeContext, logicTableName)) {
            Collection indexNames = indexSegments.stream().map(each -> each.getIndexName().getIdentifier().getValue()).collect(Collectors.toList());
            throw new ShardingDDLRouteException("DROP", "INDEX", indexNames);
        }
    }
}

