/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sharding.route.engine.validator.ddl.impl;

import java.util.Collections;
import java.util.List;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.statement.ddl.CreateTableStatementContext;
import org.apache.shardingsphere.infra.config.props.ConfigurationProperties;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.hint.HintValueContext;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.database.schema.model.ShardingSphereSchema;
import org.apache.shardingsphere.infra.route.context.RouteContext;
import org.apache.shardingsphere.sharding.exception.connection.ShardingDDLRouteException;
import org.apache.shardingsphere.sharding.route.engine.validator.ddl.ShardingDDLStatementValidator;
import org.apache.shardingsphere.sharding.rule.ShardingRule;
import org.apache.shardingsphere.sql.parser.statement.core.statement.ddl.CreateTableStatement;

public final class ShardingCreateTableStatementValidator
extends ShardingDDLStatementValidator {
    @Override
    public void preValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props) {
        CreateTableStatementContext createTableStatementContext = (CreateTableStatementContext)sqlStatementContext;
        CreateTableStatement createTableStatement = createTableStatementContext.getSqlStatement();
        if (!createTableStatement.isIfNotExists() && !hintValueContext.isSkipMetadataValidate()) {
            String defaultSchemaName = new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(database.getName());
            ShardingSphereSchema schema = createTableStatementContext.getTablesContext().getSchemaName().map(arg_0 -> ((ShardingSphereDatabase)database).getSchema(arg_0)).orElseGet(() -> database.getSchema(defaultSchemaName));
            this.validateTableNotExist(schema, Collections.singleton(createTableStatement.getTable()));
        }
    }

    @Override
    public void postValidate(ShardingRule shardingRule, SQLStatementContext sqlStatementContext, HintValueContext hintValueContext, List<Object> params, ShardingSphereDatabase database, ConfigurationProperties props, RouteContext routeContext) {
        CreateTableStatementContext createTableStatementContext = (CreateTableStatementContext)sqlStatementContext;
        String primaryTable = createTableStatementContext.getSqlStatement().getTable().getTableName().getIdentifier().getValue();
        if (this.isRouteUnitDataNodeDifferentSize(shardingRule, routeContext, primaryTable)) {
            throw new ShardingDDLRouteException("CREATE", "TABLE", createTableStatementContext.getTablesContext().getTableNames());
        }
    }
}

