/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mask.rule.changed;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mask.config.MaskRuleConfiguration;
import org.apache.shardingsphere.mask.config.rule.MaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.rule.MaskRule;
import org.apache.shardingsphere.mask.yaml.config.rule.YamlMaskTableRuleConfiguration;
import org.apache.shardingsphere.mask.yaml.swapper.rule.YamlMaskTableRuleConfigurationSwapper;
import org.apache.shardingsphere.mode.event.dispatch.rule.alter.AlterRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropNamedRuleItemEvent;
import org.apache.shardingsphere.mode.event.dispatch.rule.drop.DropRuleItemEvent;
import org.apache.shardingsphere.mode.spi.RuleItemConfigurationChangedProcessor;

public final class MaskTableChangedProcessor
implements RuleItemConfigurationChangedProcessor<MaskRuleConfiguration, MaskTableRuleConfiguration> {
    public MaskTableRuleConfiguration swapRuleItemConfiguration(AlterRuleItemEvent event, String yamlContent) {
        return new YamlMaskTableRuleConfigurationSwapper().swapToObject((YamlMaskTableRuleConfiguration)YamlEngine.unmarshal((String)yamlContent, YamlMaskTableRuleConfiguration.class));
    }

    public MaskRuleConfiguration findRuleConfiguration(ShardingSphereDatabase database) {
        return database.getRuleMetaData().findSingleRule(MaskRule.class).map(optional -> this.getConfiguration(optional.getConfiguration())).orElseGet(() -> new MaskRuleConfiguration(new LinkedList(), new LinkedHashMap()));
    }

    private MaskRuleConfiguration getConfiguration(MaskRuleConfiguration config) {
        return null == config.getTables() ? new MaskRuleConfiguration(new LinkedList(), config.getMaskAlgorithms()) : config;
    }

    public void changeRuleItemConfiguration(AlterRuleItemEvent event, MaskRuleConfiguration currentRuleConfig, MaskTableRuleConfiguration toBeChangedItemConfig) {
        currentRuleConfig.getTables().removeIf(each -> each.getName().equals(toBeChangedItemConfig.getName()));
        currentRuleConfig.getTables().add(toBeChangedItemConfig);
    }

    public void dropRuleItemConfiguration(DropRuleItemEvent event, MaskRuleConfiguration currentRuleConfig) {
        currentRuleConfig.getTables().removeIf(each -> each.getName().equals(((DropNamedRuleItemEvent)event).getItemName()));
    }

    public String getType() {
        return "mask.tables";
    }
}

