/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.util.yaml;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.yaml.YamlConfiguration;
import org.apache.shardingsphere.infra.util.yaml.constructor.ShardingSphereYamlConstructor;
import org.apache.shardingsphere.infra.util.yaml.representer.ShardingSphereYamlRepresenter;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.representer.Representer;

public final class YamlEngine {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends YamlConfiguration> T unmarshal(File yamlFile, Class<T> classType) throws IOException {
        try (BufferedReader inputStreamReader = Files.newBufferedReader(Paths.get(yamlFile.toURI()));){
            YamlConfiguration result = (YamlConfiguration)new Yaml((BaseConstructor)new ShardingSphereYamlConstructor(classType)).loadAs((Reader)inputStreamReader, classType);
            YamlConfiguration yamlConfiguration = null == result ? (YamlConfiguration)classType.getConstructor(new Class[0]).newInstance(new Object[0]) : result;
            return (T)yamlConfiguration;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends YamlConfiguration> T unmarshal(byte[] yamlBytes, Class<T> classType) throws IOException {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream(yamlBytes);){
            YamlConfiguration result = (YamlConfiguration)new Yaml((BaseConstructor)new ShardingSphereYamlConstructor(classType)).loadAs((InputStream)inputStream, classType);
            YamlConfiguration yamlConfiguration = null == result ? (YamlConfiguration)classType.getConstructor(new Class[0]).newInstance(new Object[0]) : result;
            return (T)yamlConfiguration;
        }
    }

    public static <T> T unmarshal(String yamlContent, Class<T> classType) {
        Object result = new Yaml((BaseConstructor)new ShardingSphereYamlConstructor(classType)).loadAs(yamlContent, classType);
        return (T)(null == result ? classType.getConstructor(new Class[0]).newInstance(new Object[0]) : result);
    }

    public static <T> T unmarshal(String yamlContent, Class<T> classType, boolean skipMissingProps) {
        Representer representer = new Representer(new DumperOptions());
        representer.getPropertyUtils().setSkipMissingProperties(skipMissingProps);
        Object result = new Yaml((BaseConstructor)new ShardingSphereYamlConstructor(classType), representer).loadAs(yamlContent, classType);
        return (T)(null == result ? classType.getConstructor(new Class[0]).newInstance(new Object[0]) : result);
    }

    public static String marshal(Object value) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setLineBreak(DumperOptions.LineBreak.getPlatformLineBreak());
        if (value instanceof Collection) {
            return new Yaml((Representer)new ShardingSphereYamlRepresenter(dumperOptions), dumperOptions).dumpAs(value, null, DumperOptions.FlowStyle.BLOCK);
        }
        return new Yaml((Representer)new ShardingSphereYamlRepresenter(dumperOptions), dumperOptions).dumpAsMap(value);
    }

    @Generated
    private YamlEngine() {
    }
}

