/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.metadata.persist.node.StatesNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.assisted.CreateDatabaseListenerAssistedEvent;
import org.apache.shardingsphere.mode.event.dispatch.assisted.DropDatabaseListenerAssistedEvent;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;
import org.apache.shardingsphere.mode.persist.pojo.ListenerAssisted;
import org.apache.shardingsphere.mode.persist.pojo.ListenerAssistedType;

public final class ListenerAssistedDispatchEventBuilder
implements DispatchEventBuilder<DispatchEvent> {
    @Override
    public String getSubscribedKey() {
        return StatesNode.getListenerAssistedNodePath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED);
    }

    @Override
    public Optional<DispatchEvent> build(DataChangedEvent event) {
        Optional databaseName = StatesNode.getDatabaseNameByListenerAssistedNodePath((String)event.getKey());
        if (!databaseName.isPresent()) {
            return Optional.empty();
        }
        ListenerAssistedType listenerAssistedType = ((ListenerAssisted)YamlEngine.unmarshal((String)event.getValue(), ListenerAssisted.class)).getListenerAssistedType();
        return Optional.of(ListenerAssistedType.CREATE_DATABASE == listenerAssistedType ? new CreateDatabaseListenerAssistedEvent((String)databaseName.get()) : new DropDatabaseListenerAssistedEvent((String)databaseName.get()));
    }
}

