/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.event.builder;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.event.DataChangedEvent;
import org.apache.shardingsphere.mode.event.dispatch.DispatchEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.KillLocalProcessCompletedEvent;
import org.apache.shardingsphere.mode.event.dispatch.state.compute.KillLocalProcessEvent;
import org.apache.shardingsphere.mode.manager.cluster.event.builder.DispatchEventBuilder;

public final class KillProcessDispatchEventBuilder
implements DispatchEventBuilder<DispatchEvent> {
    @Override
    public String getSubscribedKey() {
        return ComputeNode.getKillProcessTriggerNodePath();
    }

    @Override
    public Collection<DataChangedEvent.Type> getSubscribedTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<DispatchEvent> build(DataChangedEvent event) {
        return this.createKillLocalProcessEvent(event);
    }

    private Optional<DispatchEvent> createKillLocalProcessEvent(DataChangedEvent event) {
        Matcher matcher = this.getKillProcessTriggerMatcher(event);
        if (!matcher.find()) {
            return Optional.empty();
        }
        if (DataChangedEvent.Type.ADDED == event.getType()) {
            return Optional.of(new KillLocalProcessEvent(matcher.group(1), matcher.group(2)));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new KillLocalProcessCompletedEvent(matcher.group(2)));
        }
        return Optional.empty();
    }

    private Matcher getKillProcessTriggerMatcher(DataChangedEvent event) {
        return Pattern.compile(ComputeNode.getKillProcessTriggerNodePath() + "/([\\S]+):([\\S]+)$", 2).matcher(event.getKey());
    }
}

