/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter.rewriter;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.DatabaseNameAware;
import org.apache.shardingsphere.encrypt.rewrite.aware.EncryptConditionsAware;
import org.apache.shardingsphere.encrypt.rewrite.condition.EncryptCondition;
import org.apache.shardingsphere.encrypt.rewrite.condition.impl.EncryptBinaryCondition;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.column.EncryptColumn;
import org.apache.shardingsphere.encrypt.rule.table.EncryptTable;
import org.apache.shardingsphere.infra.binder.context.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.context.type.TableAvailable;
import org.apache.shardingsphere.infra.binder.context.type.WhereAvailable;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.ParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.builder.impl.StandardParameterBuilder;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;

public final class EncryptPredicateParameterRewriter
implements ParameterRewriter,
EncryptConditionsAware,
DatabaseNameAware {
    private final EncryptRule encryptRule;
    private Collection<EncryptCondition> encryptConditions;
    private String databaseName;

    public boolean isNeedRewrite(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && !((WhereAvailable)sqlStatementContext).getWhereSegments().isEmpty();
    }

    public void rewrite(ParameterBuilder paramBuilder, SQLStatementContext sqlStatementContext, List<Object> params) {
        String schemaName = ((TableAvailable)sqlStatementContext).getTablesContext().getSchemaName().orElseGet(() -> new DatabaseTypeRegistry(sqlStatementContext.getDatabaseType()).getDefaultSchemaName(this.databaseName));
        for (EncryptCondition each : this.encryptConditions) {
            this.encryptParameters(paramBuilder, each.getPositionIndexMap(), this.getEncryptedValues(schemaName, each, each.getValues(params)));
        }
    }

    private List<Object> getEncryptedValues(String schemaName, EncryptCondition encryptCondition, List<Object> originalValues) {
        String tableName = encryptCondition.getTableName();
        String columnName = encryptCondition.getColumnName();
        EncryptTable encryptTable = this.encryptRule.getEncryptTable(tableName);
        EncryptColumn encryptColumn = encryptTable.getEncryptColumn(columnName);
        if (encryptCondition instanceof EncryptBinaryCondition && "LIKE".equals(((EncryptBinaryCondition)encryptCondition).getOperator()) && encryptColumn.getLikeQuery().isPresent()) {
            return encryptColumn.getLikeQuery().get().encrypt(this.databaseName, schemaName, tableName, columnName, originalValues);
        }
        return encryptColumn.getAssistedQuery().isPresent() ? encryptColumn.getAssistedQuery().get().encrypt(this.databaseName, schemaName, tableName, columnName, originalValues) : encryptColumn.getCipher().encrypt(this.databaseName, schemaName, tableName, columnName, originalValues);
    }

    private void encryptParameters(ParameterBuilder paramBuilder, Map<Integer, Integer> positionIndexes, List<Object> encryptValues) {
        if (!positionIndexes.isEmpty()) {
            for (Map.Entry<Integer, Integer> entry : positionIndexes.entrySet()) {
                ((StandardParameterBuilder)paramBuilder).addReplacedParameters(entry.getValue().intValue(), encryptValues.get(entry.getKey()));
            }
        }
    }

    @Generated
    public EncryptPredicateParameterRewriter(EncryptRule encryptRule) {
        this.encryptRule = encryptRule;
    }

    @Override
    @Generated
    public void setEncryptConditions(Collection<EncryptCondition> encryptConditions) {
        this.encryptConditions = encryptConditions;
    }

    @Override
    @Generated
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }
}

