/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.agent.plugin.metrics.prometheus;

import java.io.IOException;
import java.net.InetSocketAddress;
import lombok.Generated;
import org.apache.shardingsphere.agent.api.PluginConfiguration;
import org.apache.shardingsphere.agent.plugin.core.config.validator.PluginConfigurationValidator;
import org.apache.shardingsphere.agent.plugin.core.context.PluginContext;
import org.apache.shardingsphere.agent.plugin.metrics.core.exporter.impl.BuildInfoExporter;
import org.apache.shardingsphere.agent.plugin.metrics.core.exporter.impl.jdbc.JDBCMetaDataInfoExporter;
import org.apache.shardingsphere.agent.plugin.metrics.core.exporter.impl.jdbc.JDBCStateExporter;
import org.apache.shardingsphere.agent.plugin.metrics.core.exporter.impl.proxy.ProxyMetaDataInfoExporter;
import org.apache.shardingsphere.agent.plugin.metrics.core.exporter.impl.proxy.ProxyStateExporter;
import org.apache.shardingsphere.agent.plugin.metrics.prometheus.exoprter.PrometheusMetricsExporter;
import org.apache.shardingsphere.agent.spi.PluginLifecycleService;
import org.apache.shardingsphere.shade.io.prometheus.client.CollectorRegistry;
import org.apache.shardingsphere.shade.io.prometheus.client.exporter.HTTPServer;
import org.apache.shardingsphere.shade.io.prometheus.client.hotspot.DefaultExports;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PrometheusPluginLifecycleService
implements PluginLifecycleService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PrometheusPluginLifecycleService.class);
    private static final String KEY_JVM_INFORMATION_COLLECTOR_ENABLED = "jvm-information-collector-enabled";
    private HTTPServer httpServer;

    public void start(PluginConfiguration pluginConfig, boolean isEnhancedForProxy) {
        PluginContext.getInstance().setEnhancedForProxy(isEnhancedForProxy);
        PluginConfigurationValidator.validatePort((String)this.getType(), (PluginConfiguration)pluginConfig);
        this.startServer(pluginConfig, isEnhancedForProxy);
    }

    private void startServer(PluginConfiguration pluginConfig, boolean isEnhancedForProxy) {
        this.registerCollector(Boolean.parseBoolean(pluginConfig.getProps().getProperty(KEY_JVM_INFORMATION_COLLECTOR_ENABLED)), isEnhancedForProxy);
        InetSocketAddress socketAddress = this.getSocketAddress(pluginConfig);
        try {
            this.httpServer = new HTTPServer(socketAddress, CollectorRegistry.defaultRegistry, true);
            log.info("Prometheus metrics HTTP server `{}:{}` start success.", (Object)socketAddress.getHostString(), (Object)socketAddress.getPort());
        }
        catch (IOException ex) {
            log.error("Prometheus metrics HTTP server start fail.", (Throwable)ex);
        }
    }

    private void registerCollector(boolean isCollectJVMInformation, boolean isEnhancedForProxy) {
        new PrometheusMetricsExporter(new BuildInfoExporter()).register();
        if (isEnhancedForProxy) {
            this.registerCollectorForProxy();
        } else {
            this.registerCollectorForJDBC();
        }
        if (isCollectJVMInformation) {
            DefaultExports.initialize();
        }
    }

    private void registerCollectorForProxy() {
        new PrometheusMetricsExporter(new ProxyStateExporter()).register();
        new PrometheusMetricsExporter(new ProxyMetaDataInfoExporter()).register();
    }

    private void registerCollectorForJDBC() {
        new PrometheusMetricsExporter(new JDBCStateExporter()).register();
        new PrometheusMetricsExporter(new JDBCMetaDataInfoExporter()).register();
    }

    private InetSocketAddress getSocketAddress(PluginConfiguration pluginConfig) {
        return this.isNullOrEmpty(pluginConfig.getHost()) ? new InetSocketAddress(pluginConfig.getPort()) : new InetSocketAddress(pluginConfig.getHost(), pluginConfig.getPort());
    }

    private boolean isNullOrEmpty(String value) {
        return null == value || value.isEmpty();
    }

    public void close() {
        if (null != this.httpServer) {
            this.httpServer.stop();
        }
    }

    public String getType() {
        return "Prometheus";
    }
}

