/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.definition.schema;

import io.swagger.models.Swagger;
import org.apache.servicecomb.core.definition.MicroserviceMeta;
import org.apache.servicecomb.core.definition.SchemaMeta;
import org.apache.servicecomb.core.definition.SchemaUtils;
import org.apache.servicecomb.core.definition.schema.AbstractSchemaFactory;
import org.apache.servicecomb.core.definition.schema.ConsumerSchemaContext;
import org.apache.servicecomb.serviceregistry.RegistryUtils;
import org.apache.servicecomb.serviceregistry.api.registry.Microservice;
import org.apache.servicecomb.serviceregistry.client.ServiceRegistryClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class ConsumerSchemaFactory
extends AbstractSchemaFactory<ConsumerSchemaContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerSchemaFactory.class);

    public void createConsumerSchema(MicroserviceMeta microserviceMeta, Microservice microservice) {
        long start = System.currentTimeMillis();
        for (String schemaId : microservice.getSchemas()) {
            ConsumerSchemaContext context = new ConsumerSchemaContext();
            context.setMicroserviceMeta(microserviceMeta);
            context.setMicroservice(microservice);
            context.setSchemaId(schemaId);
            context.setProviderClass(null);
            this.getOrCreateSchema(context);
        }
        LOGGER.info("Loading schema for service {} token {}", (Object)microservice.getServiceId(), (Object)(System.currentTimeMillis() - start));
    }

    @Override
    protected SchemaMeta createSchema(ConsumerSchemaContext context) {
        Swagger swagger = this.loadSwagger(context);
        return this.schemaLoader.registerSchema(context.getMicroserviceMeta(), context.getSchemaId(), swagger);
    }

    @Override
    protected Swagger loadSwagger(ConsumerSchemaContext context) {
        Swagger swagger = super.loadSwagger(context);
        if (swagger != null) {
            return swagger;
        }
        ServiceRegistryClient client = RegistryUtils.getServiceRegistryClient();
        String schemaContent = client.getAggregatedSchema(context.getMicroservice().getServiceId(), context.getSchemaId());
        LOGGER.info("load schema from service center, microservice={}:{}:{}, schemaId={}, result={}", new Object[]{context.getMicroservice().getAppId(), context.getMicroservice().getServiceName(), context.getMicroservice().getVersion(), context.getSchemaId(), !StringUtils.isEmpty((Object)schemaContent)});
        LOGGER.debug(schemaContent);
        if (schemaContent != null) {
            return SchemaUtils.parseSwagger(schemaContent);
        }
        throw new Error(String.format("no schema in local, and can not get schema from service center, %s:%s", context.getMicroserviceName(), context.getSchemaId()));
    }
}

