/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.oasv.style.factory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.servicecomb.toolkit.oasv.FactoryOptions;
import org.apache.servicecomb.toolkit.oasv.style.validator.openapi.OpenApiSecuritySizeEqValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.openapi.OpenApiTagsSizeGteValidator;
import org.apache.servicecomb.toolkit.oasv.style.validator.openapi.OpenApiVersionGteValidator;
import org.apache.servicecomb.toolkit.oasv.validation.api.OpenApiValidator;
import org.apache.servicecomb.toolkit.oasv.validation.factory.ComponentsValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.InfoValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.OpenApiValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.PathsValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.ServerValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.factory.TagValidatorFactory;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.openapi.OpenApiComponentsValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.openapi.OpenApiInfoValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.openapi.OpenApiPathsValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.openapi.OpenApiServersValidator;
import org.apache.servicecomb.toolkit.oasv.validation.skeleton.openapi.OpenApiTagsValidator;
import org.springframework.stereotype.Component;

@Component
public class DefaultOpenApiValidatorFactory
implements OpenApiValidatorFactory {
    private final TagValidatorFactory tagValidatorFactory;
    private final InfoValidatorFactory infoValidatorFactory;
    private final PathsValidatorFactory pathsValidatorFactory;
    private final ComponentsValidatorFactory componentsValidatorFactory;
    private final ServerValidatorFactory serverValidatorFactory;

    public DefaultOpenApiValidatorFactory(TagValidatorFactory tagValidatorFactory, InfoValidatorFactory infoValidatorFactory, PathsValidatorFactory pathsValidatorFactory, ComponentsValidatorFactory componentsValidatorFactory, ServerValidatorFactory serverValidatorFactory) {
        this.tagValidatorFactory = tagValidatorFactory;
        this.infoValidatorFactory = infoValidatorFactory;
        this.pathsValidatorFactory = pathsValidatorFactory;
        this.componentsValidatorFactory = componentsValidatorFactory;
        this.serverValidatorFactory = serverValidatorFactory;
    }

    public List<OpenApiValidator> create(FactoryOptions options) {
        ArrayList<OpenApiValidator> validators = new ArrayList<OpenApiValidator>();
        validators.add((OpenApiValidator)new OpenApiTagsValidator(this.tagValidatorFactory.create(options)));
        validators.add((OpenApiValidator)new OpenApiInfoValidator(this.infoValidatorFactory.create(options)));
        validators.add((OpenApiValidator)new OpenApiPathsValidator(this.pathsValidatorFactory.create(options)));
        validators.add((OpenApiValidator)new OpenApiComponentsValidator(this.componentsValidatorFactory.create(options)));
        validators.add((OpenApiValidator)new OpenApiServersValidator(this.serverValidatorFactory.create(options)));
        this.addOpenApiSecuritySizeValidator(validators, options);
        this.addOpenApiTagsSizeValidator(validators, options);
        this.addOpenApiVersionGteValidator(validators, options);
        return Collections.unmodifiableList(validators);
    }

    private void addOpenApiSecuritySizeValidator(List<OpenApiValidator> validators, FactoryOptions options) {
        Integer size = options.getInteger("openAPI.security.size.eq");
        if (size != null) {
            validators.add(new OpenApiSecuritySizeEqValidator(size));
        }
    }

    private void addOpenApiTagsSizeValidator(List<OpenApiValidator> validators, FactoryOptions options) {
        Integer size = options.getInteger("openAPI.tags.size.gte");
        if (size != null) {
            validators.add(new OpenApiTagsSizeGteValidator(size));
        }
    }

    private void addOpenApiVersionGteValidator(List<OpenApiValidator> validators, FactoryOptions options) {
        String versionGte = options.getString("openAPI.openapi.gte");
        if (versionGte != null) {
            validators.add(new OpenApiVersionGteValidator(versionGte));
        }
    }
}

