/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.impl.ints;

import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.AbstractPrimitiveWriters;
import org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.repeated.RepeatedPrimitiveWriteSchemas;

public class UInt32PackedWriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        return RepeatedPrimitiveWriteSchemas.create(protoField, propertyDescriptor, new UInt32PackedWriters(protoField));
    }

    private static class UInt32PackedWriters
    extends AbstractPrimitiveWriters<int[], Integer> {
        public UInt32PackedWriters(Field protoField) {
            super(protoField);
            this.primitiveArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (int element : array) {
                    output.writePackedUInt32(element);
                }
            });
            this.arrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (Integer element : array) {
                    if (element != null) {
                        output.writePackedUInt32(element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
            this.collectionWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, collection) -> {
                for (Integer element : collection) {
                    if (element != null) {
                        output.writePackedUInt32(element);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
            this.stringArrayWriter = (o, value) -> o.writeObject(this.tag, this.tagSize, value, (output, array) -> {
                for (String element : array) {
                    if (element != null) {
                        int parsedValue = Integer.parseInt(element, 10);
                        output.writePackedUInt32(parsedValue);
                        continue;
                    }
                    ProtoUtils.throwNotSupportNullElement(protoField);
                }
            });
        }
    }
}

