/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.core.Serde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import org.apache.log4j.Logger;
import org.apache.sedona.viz.utils.Pixel;

public class PixelSerializer
extends Serializer<Pixel> {
    static final Logger log = Logger.getLogger(PixelSerializer.class);

    public void write(Kryo kryo, Output output, Pixel object) {
        log.debug((Object)"Serializing Pixel...");
        output.writeInt((int)object.getX());
        output.writeInt((int)object.getY());
        output.writeInt(object.getResolutionX());
        output.writeInt(object.getResolutionY());
        output.writeBoolean(object.isDuplicate());
        output.writeInt(object.getCurrentPartitionId());
    }

    public Pixel read(Kryo kryo, Input input, Class<Pixel> type) {
        log.debug((Object)"De-serializing Pixel...");
        int X = input.readInt();
        int Y = input.readInt();
        int ResolutionX = input.readInt();
        int ResolutionY = input.readInt();
        boolean isDuplicate = input.readBoolean();
        int currentPartitionId = input.readInt();
        Pixel pixel = new Pixel(X, Y, ResolutionX, ResolutionY, isDuplicate, currentPartitionId);
        return pixel;
    }

    public Pixel readPixel(byte[] inputArray) {
        Kryo kryo = new Kryo();
        Input input = new Input(inputArray);
        return this.read(kryo, input, Pixel.class);
    }
}

